/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.exporter.CompositeExporterTransferStrategy;
import com.refinedmods.refinedstorage.common.exporter.ExporterContainerMenu;
import com.refinedmods.refinedstorage.common.exporter.ExporterData;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.SchedulingModeContainer;
import com.refinedmods.refinedstorage.common.support.SchedulingModeType;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporterBlockEntity
extends AbstractCableLikeBlockEntity<ExporterNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<ExporterData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExporterBlockEntity.class);
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.EXPORTER, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getExporter().getEnergyUsage();
        ((ExporterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.method_5431();
        class_1937 patt0$temp = this.field_11863;
        if (patt0$temp instanceof class_3218) {
            class_3218 serverLevel = (class_3218)patt0$temp;
            this.initialize(serverLevel);
        }
    });
    private final FilterWithFuzzyMode filter;
    private final SchedulingModeContainer schedulingModeContainer;

    protected AbstractExporterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getExporter(), pos, state, new ExporterNetworkNode(Platform.INSTANCE.getConfig().getExporter().getEnergyUsage()));
        this.ticker = this.upgradeContainer.getTicker();
        this.schedulingModeContainer = new SchedulingModeContainer(this::schedulingModeChanged);
        this.filter = FilterWithFuzzyMode.createAndListenForFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractExporterBlockEntity)this).method_5431(), this::setFilters);
    }

    private void schedulingModeChanged(SchedulingMode schedulingMode) {
        ((ExporterNetworkNode)this.mainNetworkNode).setSchedulingMode(schedulingMode);
        this.method_5431();
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ExporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized exporter at {} with strategy {}", (Object)this.field_11867, (Object)strategy);
        ((ExporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ExporterTransferStrategy createStrategy(class_3218 serverLevel, class_2350 direction) {
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        List<ExporterTransferStrategyFactory> factories = RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().getAll();
        Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies = factories.stream().collect(Collectors.toMap(ExporterTransferStrategyFactory::getResourceType, factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer, this.filter.isFuzzyMode())));
        return new CompositeExporterTransferStrategy(strategies);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.schedulingModeContainer.writeToTag(tag);
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.schedulingModeContainer.loadFromTag(tag);
        this.filter.load(tag, provider);
    }

    void setSchedulingModeType(SchedulingModeType type) {
        this.schedulingModeContainer.setType(type);
    }

    SchedulingModeType getSchedulingModeType() {
        return this.schedulingModeContainer.getType();
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.EXPORTER);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new ExporterContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((ExporterNetworkNode)this.mainNetworkNode).getLastResult(i)), false);
    }

    private ExportingIndicator toExportingIndicator(@Nullable ExporterTransferStrategy.Result result) {
        ExporterTransferStrategy.Result result2 = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"DESTINATION_DOES_NOT_ACCEPT", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (ExporterTransferStrategy.Result)result2, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public ExporterData getMenuData() {
        ResourceContainer filterContainer = this.filter.getFilterContainer();
        ResourceContainerData resourceContainerData = ResourceContainerData.of(filterContainer);
        return new ExporterData(resourceContainerData, this.getExportingIndicators().getAll());
    }

    @Override
    public class_9142<class_9129, ExporterData> getMenuCodec() {
        return ExporterData.STREAM_CODEC;
    }

    void setFilters(List<ResourceKey> filters) {
        ((ExporterNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

