/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.exporter;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Map;
import java.util.Objects;

class CompositeExporterTransferStrategy
implements ExporterTransferStrategy {
    private final Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies;
    private final ExporterTransferStrategy fastItemStrategy;
    private final ExporterTransferStrategy fastFluidStrategy;

    CompositeExporterTransferStrategy(Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies) {
        this.strategies = strategies;
        this.fastItemStrategy = Objects.requireNonNull(strategies.get(ItemResource.class));
        this.fastFluidStrategy = Objects.requireNonNull(strategies.get(FluidResource.class));
    }

    @Override
    public ExporterTransferStrategy.Result transfer(ResourceKey resource, Actor actor, Network network) {
        Class<?> resourceClass = resource.getClass();
        if (resourceClass == ItemResource.class) {
            return this.fastItemStrategy.transfer(resource, actor, network);
        }
        if (resourceClass == FluidResource.class) {
            return this.fastFluidStrategy.transfer(resource, actor, network);
        }
        ExporterTransferStrategy strategy = this.strategies.get(resourceClass);
        return strategy == null ? ExporterTransferStrategy.Result.DESTINATION_DOES_NOT_ACCEPT : strategy.transfer(resource, actor, network);
    }
}

