/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryFilter;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.ClientCraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGridResultSlot;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import org.apiguardian.api.API;

public abstract class AbstractCraftingGridContainerMenu
extends AbstractGridContainerMenu {
    private static final int Y_OFFSET_BETWEEN_PLAYER_INVENTORY_AND_FIRST_CRAFTING_MATRIX_SLOT = 69;
    private final class_1657 gridPlayer;
    private final CraftingGrid craftingGrid;
    private final List<class_1735> craftingMatrixSlots = new ArrayList<class_1735>();
    @Nullable
    private Consumer<Boolean> activenessListener;
    @Nullable
    private ResourceRepositoryFilter<GridResource> filterBeforeFilteringBasedOnCraftingMatrixItems;

    protected AbstractCraftingGridContainerMenu(class_3917<? extends AbstractGridContainerMenu> menuType, int syncId, class_1661 playerInventory, GridData gridData) {
        super(menuType, syncId, playerInventory, gridData);
        this.craftingGrid = new ClientCraftingGrid();
        this.gridPlayer = playerInventory.field_7546;
    }

    protected AbstractCraftingGridContainerMenu(class_3917<? extends AbstractGridContainerMenu> menuType, int syncId, class_1661 playerInventory, CraftingGrid craftingGrid) {
        super(menuType, syncId, playerInventory, craftingGrid);
        this.craftingGrid = craftingGrid;
        this.gridPlayer = playerInventory.field_7546;
    }

    public void setActivenessListener(@Nullable Consumer<Boolean> activenessListener) {
        this.activenessListener = activenessListener;
    }

    @Override
    public void onActiveChanged(boolean newActive) {
        super.onActiveChanged(newActive);
        if (this.activenessListener != null) {
            this.activenessListener.accept(newActive);
        }
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (slot instanceof CraftingGridResultSlot) {
            return false;
        }
        return super.method_7613(stack, slot);
    }

    @Override
    public class_1799 method_7601(class_1657 actor, int slotIndex) {
        CraftingGridResultSlot resultSlot;
        class_1735 slot = this.method_7611(slotIndex);
        if (!actor.method_37908().method_8608() && slot instanceof CraftingGridResultSlot && (resultSlot = (CraftingGridResultSlot)slot).method_7681()) {
            class_1799 craftedStack = resultSlot.onQuickCraft(actor);
            this.craftingGrid.acceptQuickCraft(actor, craftedStack);
            return class_1799.field_8037;
        }
        return super.method_7601(actor, slotIndex);
    }

    @Override
    public void resized(int playerInventoryY, int topYStart, int topYEnd) {
        super.resized(playerInventoryY, topYStart, topYEnd);
        this.craftingMatrixSlots.clear();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotX = 26 + x % 3 * 18;
                int slotY = playerInventoryY - 69 + y % 3 * 18;
                this.craftingMatrixSlots.add(this.method_7621(new class_1735((class_1263)this.craftingGrid.getCraftingMatrix(), x + y * 3, slotX, slotY)));
            }
        }
        this.method_7621((class_1735)new CraftingGridResultSlot(this.gridPlayer, this.craftingGrid, 134, playerInventoryY - 69 + 18));
    }

    public List<class_1735> getCraftingMatrixSlots() {
        return this.craftingMatrixSlots;
    }

    public void clear(boolean toPlayerInventory) {
        this.craftingGrid.clearMatrix(this.gridPlayer, toPlayerInventory);
    }

    @API(status=API.Status.INTERNAL)
    public MutableResourceList getAvailableListForRecipeTransfer() {
        MutableResourceList available = this.getRepository().copyBackingList();
        this.addContainerToList((class_1263)this.craftingGrid.getCraftingMatrix(), available);
        this.addContainerToList((class_1263)this.gridPlayer.method_31548(), available);
        return available;
    }

    private void addContainerToList(class_1263 container, MutableResourceList available) {
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (stack.method_7960()) continue;
            available.add(ItemResource.ofItemStack(stack), stack.method_7947());
        }
    }

    public void transferRecipe(List<List<ItemResource>> recipe) {
        this.craftingGrid.transferRecipe(this.gridPlayer, recipe);
    }

    public void filterBasedOnCraftingMatrixItems() {
        Set<ItemResource> craftingMatrixItems = this.getCraftingMatrixItems();
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = this.getRepository().setFilterAndSort((view, resource) -> {
            ItemGridResource itemResource;
            return resource instanceof ItemGridResource && craftingMatrixItems.contains((itemResource = (ItemGridResource)resource).getItemResource());
        });
    }

    private Set<ItemResource> getCraftingMatrixItems() {
        HashSet<ItemResource> craftingMatrixItems = new HashSet<ItemResource>();
        for (int i = 0; i < this.craftingGrid.getCraftingMatrix().method_5439(); ++i) {
            class_1799 craftingMatrixStack = this.craftingGrid.getCraftingMatrix().method_5438(i);
            if (craftingMatrixStack.method_7960()) continue;
            craftingMatrixItems.add(ItemResource.ofItemStack(craftingMatrixStack));
        }
        return craftingMatrixItems;
    }

    public void stopFilteringBasedOnCraftingMatrixItems() {
        if (this.filterBeforeFilteringBasedOnCraftingMatrixItems == null) {
            return;
        }
        this.getRepository().setFilterAndSort(this.filterBeforeFilteringBasedOnCraftingMatrixItems);
        this.filterBeforeFilteringBasedOnCraftingMatrixItems = null;
    }

    @Override
    @Nullable
    protected ResourceKey getResourceForAutocraftableHint(class_1735 slot) {
        if (slot.field_7871 == this.craftingGrid.getCraftingMatrix() || slot.field_7871 == this.craftingGrid.getCraftingResult()) {
            return ItemResource.ofItemStack(slot.method_7677());
        }
        return super.getResourceForAutocraftableHint(slot);
    }

    @Override
    public boolean isLargeSlot(class_1735 slot) {
        return slot.field_7871 == this.craftingGrid.getCraftingResult() || super.isLargeSlot(slot);
    }
}

