/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.FuzzyGridOperations;
import com.refinedmods.refinedstorage.common.grid.SecuredGridOperations;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;

public abstract class AbstractGridBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<GridNetworkNode>
implements Grid {
    protected AbstractGridBlockEntity(class_2591<? extends AbstractGridBlockEntity> type, class_2338 pos, class_2680 state, long energyUsage) {
        super(type, pos, state, new GridNetworkNode(energyUsage));
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(GridNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).priority(Integer.MAX_VALUE).connectionStrategy(new ColoredConnectionStrategy(() -> ((AbstractGridBlockEntity)this).method_11010(), this.method_11016())).build();
    }

    @Override
    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(StorageNetworkComponent.class).getResources(actorType);
    }

    @Override
    public Set<PlatformResourceKey> getAutocraftableResources() {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(AutocraftingNetworkComponent.class).getOutputs().stream().filter(PlatformResourceKey.class::isInstance).map(PlatformResourceKey.class::cast).collect(Collectors.toSet());
    }

    @Override
    public GridOperations createOperations(ResourceType resourceType, class_3222 player) {
        Network network = Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork());
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        PlatformSecurityNetworkComponent security = network.getComponent(PlatformSecurityNetworkComponent.class);
        GridOperations operations = resourceType.createGridOperations(rootStorage, new PlayerActor((class_1657)player));
        SecuredGridOperations secured = new SecuredGridOperations(player, security, operations);
        if (rootStorage instanceof FuzzyRootStorage) {
            FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
            return new FuzzyGridOperations(player, fuzzyRootStorage, secured);
        }
        return secured;
    }

    @Override
    public boolean isGridActive() {
        return ((GridNetworkNode)this.mainNetworkNode).isActive();
    }

    @Override
    public Storage getItemStorage() {
        return Objects.requireNonNull(((GridNetworkNode)this.mainNetworkNode).getNetwork()).getComponent(StorageNetworkComponent.class);
    }

    @Override
    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        ((GridNetworkNode)this.mainNetworkNode).addWatcher(watcher, actorType);
    }

    @Override
    public void removeWatcher(GridWatcher watcher) {
        ((GridNetworkNode)this.mainNetworkNode).removeWatcher(watcher);
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getPreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getTreePreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getMaxAmount(resource, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        Network network = ((GridNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return network.getComponent(AutocraftingNetworkComponent.class).startTask(resource, amount, actor, notify, cancellationToken);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public boolean canMenuStayOpen(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }
}

