/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.grid.AbstractGridBlockEntity;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.CraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.DirectCommitExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.SnapshotExtractTransaction;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import net.minecraft.class_9694;

public class CraftingGridBlockEntity
extends AbstractGridBlockEntity
implements BlockEntityWithDrops,
NetworkNodeExtendedMenuProvider<GridData>,
CraftingGrid {
    private static final String TAG_MATRIX = "matrix";
    private final RecipeMatrix<class_3955, class_9694> craftingRecipe = RecipeMatrix.crafting(() -> ((CraftingGridBlockEntity)this).method_5431(), () -> ((CraftingGridBlockEntity)this).method_10997());

    public CraftingGridBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getCraftingGrid(), pos, state, Platform.INSTANCE.getConfig().getCraftingGrid().getEnergyUsage());
    }

    @Override
    public RecipeMatrixContainer getCraftingMatrix() {
        return this.craftingRecipe.getMatrix();
    }

    @Override
    public class_1731 getCraftingResult() {
        return this.craftingRecipe.getResult();
    }

    @Override
    public class_2371<class_1799> getRemainingItems(class_1657 player, class_9694 input) {
        return this.craftingRecipe.getRemainingItems(this.field_11863, player, input);
    }

    @Override
    public ExtractTransaction startExtractTransaction(class_1657 player, boolean directCommit) {
        return this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(storage -> directCommit ? new DirectCommitExtractTransaction((RootStorage)storage) : new SnapshotExtractTransaction(player, (RootStorage)storage, this.getCraftingMatrix())).orElse(ExtractTransaction.NOOP);
    }

    @Override
    public boolean clearMatrix(class_1657 player, boolean toPlayerInventory) {
        return toPlayerInventory ? this.getCraftingMatrix().clearToPlayerInventory(player) : this.clearMatrixIntoStorage(player);
    }

    private boolean clearMatrixIntoStorage(class_1657 player) {
        return this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(storage -> this.getCraftingMatrix().clearIntoStorage((RootStorage)storage, player)).orElse(false);
    }

    @Override
    public void transferRecipe(class_1657 player, List<List<ItemResource>> recipe) {
        this.getCraftingMatrix().transferRecipe(player, this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).orElse(null), recipe);
    }

    @Override
    public void acceptQuickCraft(class_1657 player, class_1799 craftedStack) {
        if (player.method_31548().method_7394(craftedStack)) {
            return;
        }
        long inserted = this.getNetwork().map(network -> network.getComponent(StorageNetworkComponent.class)).map(rootStorage -> rootStorage.insert(ItemResource.ofItemStack(craftedStack), craftedStack.method_7947(), Action.EXECUTE, new PlayerActor(player))).orElse(0L);
        if (inserted != (long)craftedStack.method_7947()) {
            long remainder = (long)craftedStack.method_7947() - inserted;
            class_1799 remainderStack = craftedStack.method_46651((int)remainder);
            player.method_7328(remainderStack, false);
        }
    }

    @Override
    public GridData getMenuData() {
        return GridData.of(this);
    }

    @Override
    public class_9142<class_9129, GridData> getMenuCodec() {
        return GridData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.CRAFTING_GRID);
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new CraftingGridContainerMenu(syncId, inventory, this);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_MATRIX, (class_2520)this.craftingRecipe.writeToTag(provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545(TAG_MATRIX)) {
            this.craftingRecipe.readFromTag(tag.method_10562(TAG_MATRIX), provider);
        }
    }

    @Override
    public void method_31662(class_1937 level) {
        super.method_31662(level);
        this.craftingRecipe.updateResult(level);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.craftingRecipe.getMatrix().method_5439(); ++i) {
            drops.add((Object)this.craftingRecipe.getMatrix().method_5438(i));
        }
        return drops;
    }

    private Optional<Network> getNetwork() {
        if (!((GridNetworkNode)this.mainNetworkNode).isActive()) {
            return Optional.empty();
        }
        return Optional.ofNullable(((GridNetworkNode)this.mainNetworkNode).getNetwork());
    }
}

