/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1732;
import net.minecraft.class_1734;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_8566;
import net.minecraft.class_9694;

class CraftingGridResultSlot
extends class_1734 {
    private final CraftingGrid craftingGrid;

    CraftingGridResultSlot(class_1657 player, CraftingGrid craftingGrid, int x, int y) {
        super(player, (class_8566)craftingGrid.getCraftingMatrix(), (class_1263)craftingGrid.getCraftingResult(), 0, x, y);
        this.craftingGrid = craftingGrid;
    }

    public class_1799 onQuickCraft(class_1657 player) {
        int crafted;
        class_1799 singleResultStack = this.method_7677().method_7972();
        int maxCrafted = singleResultStack.method_7914();
        try (ExtractTransaction transaction = this.craftingGrid.startExtractTransaction(player, false);){
            for (crafted = 0; class_1799.method_31577((class_1799)singleResultStack, (class_1799)this.method_7677()) && crafted < maxCrafted; crafted += singleResultStack.method_7947()) {
                this.doTake(player, transaction, singleResultStack);
            }
        }
        return singleResultStack.method_46651(crafted);
    }

    public void method_7667(class_1657 player, class_1799 stack) {
        if (player.method_37908().method_8608()) {
            return;
        }
        try (ExtractTransaction transaction = this.craftingGrid.startExtractTransaction(player, true);){
            this.doTake(player, transaction, stack);
        }
    }

    private void doTake(class_1657 player, ExtractTransaction transaction, class_1799 stack) {
        this.fireCraftingEvents(player, stack.method_7972());
        class_9694.class_9765 positioned = this.craftingGrid.getCraftingMatrix().method_60501();
        class_9694 input = positioned.comp_2795();
        int left = positioned.comp_2796();
        int top = positioned.comp_2797();
        class_2371<class_1799> remainingItems = this.craftingGrid.getRemainingItems(player, input);
        for (int y = 0; y < input.method_59992(); ++y) {
            for (int x = 0; x < input.method_59991(); ++x) {
                int index = x + left + (y + top) * this.craftingGrid.getCraftingMatrix().method_17398();
                class_1799 matrixStack = this.craftingGrid.getCraftingMatrix().method_5438(index);
                int recipeIndex = x + y * input.method_59991();
                class_1799 remainingItem = (class_1799)remainingItems.get(recipeIndex);
                if (!remainingItem.method_7960()) {
                    this.useIngredientWithRemainingItem(player, index, remainingItem);
                    continue;
                }
                if (matrixStack.method_7960()) continue;
                this.useIngredient(player, transaction, index, matrixStack);
            }
        }
        this.craftingGrid.getCraftingMatrix().changed();
    }

    private void useIngredientWithRemainingItem(class_1657 player, int index, class_1799 remainingItem) {
        class_1799 matrixStack = this.decrementMatrixSlot(index);
        if (matrixStack.method_7960()) {
            this.craftingGrid.getCraftingMatrix().method_5447(index, remainingItem);
        } else if (class_1799.method_31577((class_1799)matrixStack, (class_1799)remainingItem)) {
            remainingItem.method_7933(matrixStack.method_7947());
            this.craftingGrid.getCraftingMatrix().method_5447(index, remainingItem);
        } else if (!player.method_31548().method_7394(remainingItem)) {
            player.method_7328(remainingItem, false);
        }
    }

    private void useIngredient(class_1657 player, ExtractTransaction transaction, int index, class_1799 matrixStack) {
        if (matrixStack.method_7947() > 1 || !transaction.extract(ItemResource.ofItemStack(matrixStack), player)) {
            this.decrementMatrixSlot(index);
        }
    }

    private class_1799 decrementMatrixSlot(int index) {
        RecipeMatrixContainer matrix = this.craftingGrid.getCraftingMatrix();
        matrix.method_5434(index, 1);
        return matrix.method_5438(index);
    }

    private void fireCraftingEvents(class_1657 player, class_1799 crafted) {
        crafted.method_7982(player.method_37908(), player, crafted.method_7947());
        Platform.INSTANCE.onItemCrafted(player, crafted, (class_8566)this.craftingGrid.getCraftingMatrix());
        class_1263 class_12632 = this.field_7871;
        if (class_12632 instanceof class_1732) {
            class_1732 recipeHolder = (class_1732)class_12632;
            recipeHolder.method_7664(player, List.of(crafted));
        }
    }
}

