/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyGridOperations
implements GridOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuzzyGridOperations.class);
    private static final class_2561 INACCURATE_EXTRACTION = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction");
    private static final class_2561 CHECK_CHAT_FOR_MORE_DETAILS = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.check_chat_for_more_details");
    private static final class_2561 READ_MORE = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.read_more").method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://refinedmods.com/refined-storage/troubleshooting/inaccurate-extraction.html")).method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)));
    private final class_3222 player;
    private final FuzzyRootStorage fuzzyRootStorage;
    private final GridOperations delegate;

    public FuzzyGridOperations(class_3222 player, FuzzyRootStorage fuzzyRootStorage, GridOperations delegate) {
        this.player = player;
        this.fuzzyRootStorage = fuzzyRootStorage;
        this.delegate = delegate;
    }

    @Override
    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        boolean success = this.delegate.extract(resource, extractMode, destination);
        if (!success) {
            LOGGER.warn("Failed to extract resource in Grid: {}", (Object)resource);
            if (resource instanceof ItemResource) {
                ItemResource itemResource = (ItemResource)resource;
                itemResource.components().method_57846().forEach(e -> {
                    class_9331 componentType = (class_9331)e.getKey();
                    class_2960 key = class_7923.field_49658.method_10221((Object)componentType);
                    LOGGER.warn("Component {} = {}", (Object)key, e.getValue());
                });
            }
        }
        if (!success && this.tryFuzzyExtractBecauseModHasUnstableDataComponentEquality(resource, extractMode, destination)) {
            return true;
        }
        return success;
    }

    private boolean tryFuzzyExtractBecauseModHasUnstableDataComponentEquality(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        for (ResourceKey fuzzyResource : this.fuzzyRootStorage.getFuzzy(resource)) {
            if (!this.delegate.extract(fuzzyResource, extractMode, destination)) continue;
            String modId = FuzzyGridOperations.getModId(resource);
            class_5250 baseMessage = IdentifierUtil.createTranslation("gui", "grid.inaccurate_extraction.due_to_bug_in_other_mod_wrong_resource_maybe_extracted", modId).method_27693(" ");
            RefinedStorageApi.INSTANCE.sendMessage(this.player, INACCURATE_EXTRACTION, (class_2561)baseMessage.method_27661().method_10852(CHECK_CHAT_FOR_MORE_DETAILS));
            this.player.method_43496((class_2561)baseMessage.method_27661().method_10852(READ_MORE));
            return true;
        }
        return false;
    }

    private static String getModId(ResourceKey resource) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            return class_7923.field_41178.method_10221((Object)itemResource.item()).method_12836();
        }
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            return class_7923.field_41173.method_10221((Object)fluidResource.fluid()).method_12836();
        }
        return "<unknown>";
    }

    @Override
    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        return this.delegate.insert(resource, insertMode, source);
    }
}

