/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class SecuredGridOperations
implements GridOperations {
    private static final class_5250 CANNOT_EXTRACT_MESSAGE = IdentifierUtil.createTranslation("misc", "no_permission.extract");
    private static final class_5250 CANNOT_INSERT_MESSAGE = IdentifierUtil.createTranslation("misc", "no_permission.insert");
    private final class_3222 player;
    private final PlatformSecurityNetworkComponent securityNetworkComponent;
    private final GridOperations delegate;

    public SecuredGridOperations(class_3222 player, PlatformSecurityNetworkComponent securityNetworkComponent, GridOperations delegate) {
        this.player = player;
        this.securityNetworkComponent = securityNetworkComponent;
        this.delegate = delegate;
    }

    @Override
    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        if (!this.securityNetworkComponent.isAllowed((Permission)BuiltinPermission.EXTRACT, this.player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(this.player, (class_2561)CANNOT_EXTRACT_MESSAGE);
            return false;
        }
        return this.delegate.extract(resource, extractMode, destination);
    }

    @Override
    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        if (!this.securityNetworkComponent.isAllowed((Permission)BuiltinPermission.INSERT, this.player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(this.player, (class_2561)CANNOT_INSERT_MESSAGE);
            return false;
        }
        return this.delegate.insert(resource, insertMode, source);
    }
}

