/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class SnapshotExtractTransaction
implements ExtractTransaction {
    private final PlayerActor playerActor;
    private final RootStorage rootStorage;
    private final MutableResourceList available = MutableResourceListImpl.create();
    private final MutableResourceList used = MutableResourceListImpl.create();

    public SnapshotExtractTransaction(class_1657 player, RootStorage rootStorage, RecipeMatrixContainer craftingMatrix) {
        this.playerActor = new PlayerActor(player);
        this.rootStorage = rootStorage;
        this.addAvailableItems(craftingMatrix);
    }

    private void addAvailableItems(RecipeMatrixContainer craftingMatrix) {
        for (int i = 0; i < craftingMatrix.method_5439(); ++i) {
            this.addAvailableItem(craftingMatrix, i);
        }
    }

    private void addAvailableItem(RecipeMatrixContainer craftingMatrix, int craftingMatrixSlotIndex) {
        class_1799 craftingMatrixStack = craftingMatrix.method_5438(craftingMatrixSlotIndex);
        if (craftingMatrixStack.method_7960()) {
            return;
        }
        this.addAvailableItem(craftingMatrixStack);
    }

    private void addAvailableItem(class_1799 craftingMatrixStack) {
        long amount;
        ItemResource craftingMatrixResource = ItemResource.ofItemStack(craftingMatrixStack);
        if (!this.available.contains(craftingMatrixResource) && (amount = this.rootStorage.extract(craftingMatrixResource, Integer.MAX_VALUE, Action.SIMULATE, this.playerActor)) > 0L) {
            this.available.add(craftingMatrixResource, amount);
        }
    }

    @Override
    public boolean extract(ItemResource resource, class_1657 player) {
        boolean isAvailable = this.available.contains(resource);
        if (isAvailable) {
            this.available.remove(resource, 1L);
            this.used.add(resource, 1L);
        }
        return isAvailable;
    }

    @Override
    public void close() {
        for (ResourceKey usedResource : this.used.getAll()) {
            long amountUsed = this.used.get(usedResource);
            this.rootStorage.extract(usedResource, amountUsed, Action.EXECUTE, this.playerActor);
        }
    }
}

