/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.AutocraftableResourceHint;
import com.refinedmods.refinedstorage.common.grid.NoopGridSynchronizer;
import com.refinedmods.refinedstorage.common.grid.screen.AutocraftableClientTooltipComponent;
import com.refinedmods.refinedstorage.common.grid.screen.GridSearchBoxWidget;
import com.refinedmods.refinedstorage.common.grid.screen.LastModified;
import com.refinedmods.refinedstorage.common.grid.screen.ResourceTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SortingDirectionSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SortingTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.SynchronizationModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.screen.ViewTypeSideButtonWidget;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AutoSelectedSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.RedstoneModeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.SearchIconWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighterColors;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGridScreen<T extends AbstractGridContainerMenu>
extends AbstractStretchingScreen<T> {
    protected static final int CLEAR_BUTTON_SIZE = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGridScreen.class);
    private static final class_2960 ROW_SPRITE = IdentifierUtil.createIdentifier("grid/row");
    private static final int MODIFIED_JUST_NOW_MAX_SECONDS = 10;
    private static final int COLUMNS = 9;
    private static final int DISABLED_SLOT_COLOR = -10790053;
    private static final List<String> SEARCH_FIELD_HISTORY = new ArrayList<String>();
    private static final class_2561 SEARCH_HELP = IdentifierUtil.createTranslation("gui", "grid.search_help").method_27693("\n").method_10852((class_2561)IdentifierUtil.createTranslation("gui", "grid.search_help.mod_search").method_27692(class_124.field_1080)).method_27693("\n").method_10852((class_2561)IdentifierUtil.createTranslation("gui", "grid.search_help.tag_search").method_27692(class_124.field_1080)).method_27693("\n").method_10852((class_2561)IdentifierUtil.createTranslation("gui", "grid.search_help.tooltip_search").method_27692(class_124.field_1080));
    protected final int bottomHeight;
    @Nullable
    GridSearchBoxWidget searchField;
    @Nullable
    private ResourceTypeSideButtonWidget resourceTypeSideButtonWidget;
    private int totalRows;
    private int currentGridSlotIndex;

    protected AbstractGridScreen(T menu, class_1661 playerInventory, class_2561 title, int bottomHeight) {
        super(menu, playerInventory, new TextMarquee(title, 70));
        this.bottomHeight = bottomHeight;
    }

    @Override
    protected void init(int rows) {
        LOGGER.debug("Initializing grid screen - this shouldn't happen too much!");
        if (this.searchField == null) {
            this.searchField = new GridSearchBoxWidget(this.field_22793, this.field_2776 + 94 + 1, this.field_2800 + 6 + 1, 67, new SyntaxHighlighter(SyntaxHighlighterColors.DEFAULT_COLORS), new History(SEARCH_FIELD_HISTORY));
        } else {
            this.searchField.method_46421(this.field_2776 + 94 + 1);
            this.searchField.method_46419(this.field_2800 + 6 + 1);
        }
        ((AbstractGridContainerMenu)this.method_17577()).setSearchBox(this.searchField);
        ((AbstractGridContainerMenu)this.method_17577()).getRepository().setListener(this::updateScrollbar);
        this.updateScrollbar();
        this.method_25429((class_364)this.searchField);
        if (((AbstractGridContainerMenu)this.method_17577()).hasProperty(PropertyTypes.REDSTONE_MODE)) {
            this.addSideButton(new RedstoneModeSideButtonWidget(((AbstractGridContainerMenu)this.method_17577()).getProperty(PropertyTypes.REDSTONE_MODE)));
        }
        this.addSideButton(new ViewTypeSideButtonWidget((AbstractGridContainerMenu)this.method_17577()));
        this.resourceTypeSideButtonWidget = new ResourceTypeSideButtonWidget((AbstractGridContainerMenu)this.method_17577());
        this.addSideButton(this.resourceTypeSideButtonWidget);
        this.addSideButton(new SortingDirectionSideButtonWidget((AbstractGridContainerMenu)this.method_17577()));
        this.addSideButton(new SortingTypeSideButtonWidget((AbstractGridContainerMenu)this.method_17577()));
        this.addSideButton(new AutoSelectedSideButtonWidget(this.searchField));
        this.method_37063((class_364)new SearchIconWidget(this.field_2776 + 79, this.field_2800 + 5, () -> SEARCH_HELP, this.searchField));
        boolean onlyHasNoopSynchronizer = RefinedStorageApi.INSTANCE.getGridSynchronizerRegistry().getAll().stream().allMatch(synchronizer -> synchronizer == NoopGridSynchronizer.INSTANCE);
        if (!onlyHasNoopSynchronizer) {
            this.addSideButton(new SynchronizationModeSideButtonWidget((AbstractGridContainerMenu)this.method_17577()));
            this.searchField.addListener(this::trySynchronizeFromGrid);
        }
    }

    private void trySynchronizeFromGrid(String text) {
        ((AbstractGridContainerMenu)this.method_17577()).getSynchronizer().synchronizeFromGrid(text);
    }

    protected void method_37432() {
        super.method_37432();
        this.trySynchronizeToGrid();
        if (this.resourceTypeSideButtonWidget != null) {
            this.resourceTypeSideButtonWidget.setWarningVisible(((AbstractGridContainerMenu)this.method_17577()).isResourceTypeWarningVisible());
        }
    }

    private void trySynchronizeToGrid() {
        if (this.searchField == null) {
            return;
        }
        String text = ((AbstractGridContainerMenu)this.method_17577()).getSynchronizer().getTextToSynchronizeToGrid();
        if (text == null || this.searchField.method_1882().equals(text)) {
            return;
        }
        this.searchField.method_1852(text);
    }

    private void updateScrollbar() {
        this.totalRows = (int)Math.ceil((float)((AbstractGridContainerMenu)this.method_17577()).getRepository().getViewList().size() / 9.0f);
        this.updateScrollbar(this.totalRows);
    }

    private boolean isOverStorageArea(int mouseX, int mouseY) {
        int relativeMouseX = mouseX - this.field_2776;
        int relativeMouseY = mouseY - this.field_2800;
        return relativeMouseX >= 7 && relativeMouseX <= 168 && this.isInStretchedArea(relativeMouseY);
    }

    @Override
    protected void renderStretchingBackground(class_332 graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.method_25302(this.getTexture(), x, y + 18 * row, 0, textureY, this.field_2792, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return this.bottomHeight;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected void renderRows(class_332 graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        this.currentGridSlotIndex = -1;
        for (int row = 0; row < Math.max(this.totalRows, rows); ++row) {
            boolean isOutOfFrame;
            int rowX = x + 7;
            int rowY = y + topHeight + row * 18 - this.getScrollbarOffset();
            boolean bl = isOutOfFrame = rowY < y + topHeight - 18 || rowY > y + topHeight + 18 * rows;
            if (isOutOfFrame) continue;
            this.renderRow(graphics, mouseX, mouseY, rowX, rowY, row);
        }
    }

    private void renderRow(class_332 graphics, int mouseX, int mouseY, int rowX, int rowY, int row) {
        graphics.method_52706(ROW_SPRITE, rowX, rowY, 162, 18);
        for (int column = 0; column < 9; ++column) {
            this.renderCell(graphics, mouseX, mouseY, rowX, rowY, row * 9 + column, column);
        }
    }

    private void renderCell(class_332 graphics, int mouseX, int mouseY, int rowX, int rowY, int idx, int column) {
        ResourceRepository<GridResource> repository = ((AbstractGridContainerMenu)this.method_17577()).getRepository();
        int slotX = rowX + 1 + column * 18;
        int slotY = rowY + 1;
        if (!((AbstractGridContainerMenu)this.method_17577()).isActive()) {
            this.renderDisabledSlot(graphics, slotX, slotY);
        } else {
            this.renderSlot(graphics, mouseX, mouseY, idx, repository, slotX, slotY);
        }
    }

    @Override
    protected List<class_5684> getResourceSlotTooltip(ResourceKey resource, ResourceSlot slot) {
        List<class_5684> tooltip = super.getResourceSlotTooltip(resource, slot);
        AutocraftableResourceHint autocraftableHint = ((AbstractGridContainerMenu)this.method_17577()).getAutocraftableResourceHint(slot);
        if (autocraftableHint != null) {
            tooltip.add(AutocraftableClientTooltipComponent.autocraftable(autocraftableHint));
        }
        return tooltip;
    }

    protected void method_2385(class_332 guiGraphics, class_1735 slot) {
        this.tryRenderAutocraftableResourceHintBackground(guiGraphics, slot);
        super.method_2385(guiGraphics, slot);
    }

    private void renderSlot(class_332 graphics, int mouseX, int mouseY, int idx, ResourceRepository<GridResource> repository, int slotX, int slotY) {
        boolean inBounds = mouseX >= slotX && mouseY >= slotY && mouseX <= slotX + 16 && mouseY <= slotY + 16;
        GridResource resource = null;
        if (idx < repository.getViewList().size()) {
            resource = repository.getViewList().get(idx);
            this.renderResourceWithAmount(graphics, slotX, slotY, resource);
        }
        if (inBounds && this.isOverStorageArea(mouseX, mouseY)) {
            class_465.method_33285((class_332)graphics, (int)slotX, (int)slotY, (int)0);
            if (resource != null) {
                this.currentGridSlotIndex = idx;
            }
        }
    }

    private void tryRenderAutocraftableResourceHintBackground(class_332 graphics, class_1735 slot) {
        if (!slot.method_51306() || !slot.method_7682()) {
            return;
        }
        AutocraftableResourceHint hint = ((AbstractGridContainerMenu)this.method_17577()).getAutocraftableResourceHint(slot);
        if (hint != null) {
            AbstractGridScreen.renderSlotBackground(graphics, slot.field_7873, slot.field_7872, ((AbstractGridContainerMenu)this.method_17577()).isLargeSlot(slot), hint.getColor());
        }
    }

    private void renderResourceWithAmount(class_332 graphics, int slotX, int slotY, GridResource resource) {
        if (resource.isAutocraftable(((AbstractGridContainerMenu)this.method_17577()).getRepository())) {
            AbstractGridScreen.renderSlotBackground(graphics, slotX, slotY, false, AutocraftableResourceHint.AUTOCRAFTABLE.getColor());
        } else if (resource.getAmount(((AbstractGridContainerMenu)this.method_17577()).getRepository()) == 0L) {
            AbstractGridScreen.renderSlotBackground(graphics, slotX, slotY, false, 0x66FF0000);
        }
        resource.render(graphics, slotX, slotY);
        this.renderAmount(graphics, slotX, slotY, resource);
    }

    public static void renderSlotBackground(class_332 graphics, int slotX, int slotY, boolean large, int color) {
        int offset = large ? 4 : 0;
        graphics.method_25294(slotX - offset, slotY - offset, slotX + 16 + offset, slotY + 16 + offset, color);
    }

    private void renderAmount(class_332 graphics, int slotX, int slotY, GridResource resource) {
        long amount = resource.getAmount(((AbstractGridContainerMenu)this.method_17577()).getRepository());
        String text = this.getAmountText(resource, amount);
        int color = this.getAmountColor(resource, amount);
        boolean large = this.field_22787 != null && this.field_22787.method_1573() || Platform.INSTANCE.getConfig().getGrid().isLargeFont();
        ResourceSlotRendering.renderAmount(graphics, slotX, slotY, text, color, large);
    }

    private int getAmountColor(GridResource resource, long amount) {
        if (amount == 0L) {
            if (resource.isAutocraftable(((AbstractGridContainerMenu)this.method_17577()).getRepository())) {
                return 0xFFFFFF;
            }
            return 0xFF5555;
        }
        return 0xFFFFFF;
    }

    private String getAmountText(GridResource resource, long amount) {
        if (amount == 0L && resource.isAutocraftable(((AbstractGridContainerMenu)this.method_17577()).getRepository())) {
            return class_1074.method_4662((String)IdentifierUtil.createTranslationKey("gui", "grid.craft"), (Object[])new Object[0]);
        }
        return resource.getDisplayedAmount(((AbstractGridContainerMenu)this.method_17577()).getRepository());
    }

    private void renderDisabledSlot(class_332 graphics, int slotX, int slotY) {
        graphics.method_51739(class_1921.method_51785(), slotX, slotY, slotX + 16, slotY + 16, -10790053);
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        if (this.isOverStorageArea(x, y)) {
            this.renderOverStorageAreaTooltip(graphics, x, y);
            return;
        }
        if (((AbstractGridContainerMenu)this.method_17577()).method_34255().method_7960() && this.tryRenderAutocraftableResourceHintTooltip(graphics, x, y)) {
            return;
        }
        super.method_2380(graphics, x, y);
    }

    private boolean tryRenderAutocraftableResourceHintTooltip(class_332 graphics, int x, int y) {
        if (this.field_2787 == null || !this.field_2787.method_7681()) {
            return false;
        }
        AutocraftableResourceHint hint = ((AbstractGridContainerMenu)this.method_17577()).getAutocraftableResourceHint(this.field_2787);
        if (hint == null) {
            return false;
        }
        class_1799 stack = this.field_2787.method_7677();
        List lines = this.method_51454(stack);
        List<class_5684> processedLines = Platform.INSTANCE.processTooltipComponents(stack, graphics, x, stack.method_32347(), lines);
        processedLines.add(AutocraftableClientTooltipComponent.autocraftable(hint));
        Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
        return true;
    }

    private void renderOverStorageAreaTooltip(class_332 graphics, int x, int y) {
        GridResource gridResource = this.getCurrentGridResource();
        if (gridResource != null) {
            this.renderHoveredResourceTooltip(graphics, x, y, gridResource);
            return;
        }
        class_1799 carried = ((AbstractGridContainerMenu)this.method_17577()).method_34255();
        if (carried.method_7960()) {
            return;
        }
        List<class_5684> hints = RefinedStorageClientApi.INSTANCE.getGridInsertionHints().getHints(carried);
        Platform.INSTANCE.renderTooltip(graphics, hints, x, y);
    }

    private void renderHoveredResourceTooltip(class_332 graphics, int mouseX, int mouseY, GridResource resource) {
        class_1799 class_17992;
        if (resource instanceof ItemGridResource) {
            ItemGridResource itemResource = (ItemGridResource)resource;
            class_17992 = itemResource.getItemStack();
        } else {
            class_17992 = class_1799.field_8037;
        }
        class_1799 stackContext = class_17992;
        List<class_2561> lines = resource.getTooltip();
        List<class_5684> processedLines = Platform.INSTANCE.processTooltipComponents(stackContext, graphics, mouseX, resource.getTooltipImage(), lines);
        long amount = resource.getAmount(((AbstractGridContainerMenu)this.method_17577()).getRepository());
        if (amount > 0L && Platform.INSTANCE.getConfig().getGrid().isDetailedTooltip()) {
            this.addDetailedTooltip(resource, processedLines);
        }
        if (resource.isAutocraftable(((AbstractGridContainerMenu)this.method_17577()).getRepository())) {
            processedLines.add(amount == 0L ? AutocraftableClientTooltipComponent.empty() : AutocraftableClientTooltipComponent.existing());
        }
        if (amount > 0L) {
            processedLines.addAll(resource.getExtractionHints(((AbstractGridContainerMenu)this.method_17577()).method_34255(), ((AbstractGridContainerMenu)this.method_17577()).getRepository()));
        }
        Platform.INSTANCE.renderTooltip(graphics, processedLines, mouseX, mouseY);
    }

    private void addDetailedTooltip(GridResource resource, List<class_5684> lines) {
        String amountInTooltip = resource.getAmountInTooltip(((AbstractGridContainerMenu)this.method_17577()).getRepository());
        lines.add(new SmallTextClientTooltipComponent((class_2561)IdentifierUtil.createTranslation("misc", "total", amountInTooltip).method_27692(class_124.field_1080)));
        TrackedResource trackedResource = resource.getTrackedResource(((AbstractGridContainerMenu)this.method_17577())::getTrackedResource);
        if (trackedResource != null) {
            lines.add(new SmallTextClientTooltipComponent((class_2561)this.getLastModifiedText(trackedResource).method_27692(class_124.field_1080)));
        }
    }

    private class_5250 getLastModifiedText(TrackedResource trackedResource) {
        boolean plural;
        LastModified lastModified = LastModified.calculate(trackedResource.getTime(), System.currentTimeMillis());
        if (this.isModifiedJustNow(lastModified)) {
            return IdentifierUtil.createTranslation("misc", "last_modified.just_now", trackedResource.getSourceName());
        }
        Object translationKey = lastModified.type().toString().toLowerCase();
        boolean bl = plural = lastModified.amount() != 1L;
        if (plural) {
            translationKey = (String)translationKey + "s";
        }
        return IdentifierUtil.createTranslation("misc", "last_modified." + (String)translationKey, lastModified.amount(), trackedResource.getSourceName());
    }

    private boolean isModifiedJustNow(LastModified lastModified) {
        return lastModified.type() == LastModified.Type.SECOND && lastModified.amount() <= 10L;
    }

    @API(status=API.Status.INTERNAL)
    @Nullable
    public GridResource getCurrentGridResource() {
        if (this.currentGridSlotIndex < 0) {
            return null;
        }
        List<GridResource> viewList = ((AbstractGridContainerMenu)this.field_2797).getRepository().getViewList();
        if (this.currentGridSlotIndex >= viewList.size()) {
            return null;
        }
        return viewList.get(this.currentGridSlotIndex);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.searchField != null) {
            this.searchField.method_25394(graphics, 0, 0, 0.0f);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        class_1799 carriedStack = ((AbstractGridContainerMenu)this.method_17577()).method_34255();
        GridResource resource = this.getCurrentGridResource();
        if (this.canExtract(resource, carriedStack)) {
            this.mouseClickedInGrid(clickedButton, resource);
            return true;
        }
        if (this.canInsert((int)mouseX, (int)mouseY, clickedButton, carriedStack)) {
            this.mouseClickedInGrid(clickedButton);
            return true;
        }
        if (resource != null && resource.isAutocraftable(((AbstractGridContainerMenu)this.method_17577()).getRepository()) && this.tryStartAutocrafting(resource)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    private boolean canExtract(@Nullable GridResource resource, class_1799 carriedStack) {
        return resource != null && resource.canExtract(carriedStack, ((AbstractGridContainerMenu)this.method_17577()).getRepository()) && !AbstractGridScreen.method_25441();
    }

    private boolean canInsert(int mouseX, int mouseY, int clickedButton, class_1799 carriedStack) {
        return this.isOverStorageArea(mouseX, mouseY) && !carriedStack.method_7960() && (clickedButton == 0 || clickedButton == 1);
    }

    private boolean tryStartAutocrafting(GridResource resource) {
        ResourceAmount request = resource.getAutocraftingRequest();
        if (request == null) {
            return false;
        }
        RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(List.of(request), (class_437)this);
        return true;
    }

    private void mouseClickedInGrid(int clickedButton) {
        GridInsertMode mode = clickedButton == 1 ? GridInsertMode.SINGLE_RESOURCE : GridInsertMode.ENTIRE_RESOURCE;
        boolean tryAlternatives = clickedButton == 1;
        ((AbstractGridContainerMenu)this.method_17577()).onInsert(mode, tryAlternatives);
    }

    protected void mouseClickedInGrid(int clickedButton, GridResource resource) {
        resource.onExtract(AbstractGridScreen.getExtractMode(clickedButton), AbstractGridScreen.shouldExtractToCursor(), (GridExtractionStrategy)this.method_17577());
    }

    private static GridExtractMode getExtractMode(int clickedButton) {
        if (clickedButton == 1) {
            return GridExtractMode.HALF_RESOURCE;
        }
        return GridExtractMode.ENTIRE_RESOURCE;
    }

    private static boolean shouldExtractToCursor() {
        return !class_437.method_25442();
    }

    @Override
    public boolean method_25401(double x, double y, double z, double delta) {
        boolean up;
        boolean bl = up = delta > 0.0;
        if (this.isOverStorageArea((int)x, (int)y)) {
            GridResource resource = this.getCurrentGridResource();
            if (resource != null) {
                this.mouseScrolledInGrid(up, resource);
            }
        } else if (this.field_2787 != null && this.field_2787.method_7681() && !(this.field_2787 instanceof DisabledSlot)) {
            this.mouseScrolledInInventory(up, this.field_2787);
        }
        return super.method_25401(x, y, z, delta);
    }

    private void mouseScrolledInInventory(boolean up, class_1735 slot) {
        ((AbstractGridContainerMenu)this.method_17577()).getRepository().setPreventSorting(true);
        int slotIndex = slot.method_34266();
        this.mouseScrolledInInventory(up, slot.method_7677(), slotIndex);
    }

    private void mouseScrolledInInventory(boolean up, class_1799 stack, int slotIndex) {
        GridScrollMode scrollMode = AbstractGridScreen.getScrollModeWhenScrollingOnInventoryArea(up);
        if (scrollMode == null) {
            return;
        }
        ((AbstractGridContainerMenu)this.method_17577()).onScroll(ItemResource.ofItemStack(stack), scrollMode, slotIndex);
    }

    private void mouseScrolledInGrid(boolean up, GridResource resource) {
        ((AbstractGridContainerMenu)this.method_17577()).getRepository().setPreventSorting(true);
        GridScrollMode scrollMode = AbstractGridScreen.getScrollModeWhenScrollingOnGridArea(up);
        if (scrollMode == null) {
            return;
        }
        resource.onScroll(scrollMode, (GridScrollingStrategy)this.method_17577());
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnInventoryArea(boolean up) {
        if (class_437.method_25442()) {
            return up ? GridScrollMode.INVENTORY_TO_GRID : GridScrollMode.GRID_TO_INVENTORY;
        }
        return null;
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnGridArea(boolean up) {
        boolean shift = class_437.method_25442();
        boolean ctrl = class_437.method_25441();
        if (shift && ctrl) {
            return null;
        }
        return AbstractGridScreen.getScrollModeWhenScrollingOnGridArea(up, shift, ctrl);
    }

    @Nullable
    private static GridScrollMode getScrollModeWhenScrollingOnGridArea(boolean up, boolean shift, boolean ctrl) {
        if (up) {
            if (shift) {
                return GridScrollMode.INVENTORY_TO_GRID;
            }
        } else {
            if (shift) {
                return GridScrollMode.GRID_TO_INVENTORY;
            }
            if (ctrl) {
                return GridScrollMode.GRID_TO_CURSOR;
            }
        }
        return null;
    }

    public boolean method_25400(char unknown1, int unknown2) {
        return this.searchField != null && this.searchField.method_25400(unknown1, unknown2) || super.method_25400(unknown1, unknown2);
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (class_437.method_25442() && Platform.INSTANCE.getConfig().getGrid().isPreventSortingWhileShiftIsDown()) {
            ((AbstractGridContainerMenu)this.method_17577()).getRepository().setPreventSorting(true);
        }
        if (this.searchField != null && this.searchField.method_25404(key, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    public boolean method_16803(int key, int scanCode, int modifiers) {
        if (((AbstractGridContainerMenu)this.method_17577()).getRepository().setPreventSorting(false)) {
            ((AbstractGridContainerMenu)this.method_17577()).getRepository().sort();
        }
        return super.method_16803(key, scanCode, modifiers);
    }
}

