/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.grid.AbstractCraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.CraftingGridMatrixCloseBehavior;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.CustomButton;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_7919;
import net.minecraft.class_8666;

public class CraftingGridScreen
extends AbstractGridScreen<AbstractCraftingGridContainerMenu> {
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/crafting_grid.png");
    private static final class_8666 CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/move_down"), IdentifierUtil.createIdentifier("widget/move_down_disabled"), IdentifierUtil.createIdentifier("widget/move_down_focused"), IdentifierUtil.createIdentifier("widget/move_down_disabled"));
    private static final class_8666 CLEAR_BUTTON_TO_NETWORK_SPRITES = new class_8666(IdentifierUtil.createIdentifier("widget/move_up"), IdentifierUtil.createIdentifier("widget/move_up_disabled"), IdentifierUtil.createIdentifier("widget/move_up_focused"), IdentifierUtil.createIdentifier("widget/move_up_disabled"));
    private static final class_2960 CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT = IdentifierUtil.createIdentifier("crafting_grid/crafting_matrix_filtering_slot_highlight");
    @Nullable
    private CustomButton clearToNetworkButton;
    private boolean filteringBasedOnCraftingMatrixItems;

    public CraftingGridScreen(AbstractCraftingGridContainerMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title, 156);
        this.field_25270 = 134;
        this.field_2792 = 193;
        this.field_2779 = 229;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int clearToNetworkButtonX = this.getClearButtonX(0);
        int clearToInventoryButtonX = this.getClearButtonX(1);
        int clearButtonY = this.field_2800 + this.field_2779 - this.bottomHeight + 4;
        this.clearToNetworkButton = this.createClearButton(clearToNetworkButtonX, clearButtonY, false);
        this.setClearToNetworkButtonActive(((AbstractCraftingGridContainerMenu)this.method_17577()).isActive());
        ((AbstractCraftingGridContainerMenu)this.method_17577()).setActivenessListener(this::setClearToNetworkButtonActive);
        this.method_37063((class_364)this.clearToNetworkButton);
        this.method_37063((class_364)this.createClearButton(clearToInventoryButtonX, clearButtonY, true));
    }

    private int getClearButtonX(int i) {
        return this.field_2776 + 81 + 9 * i;
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        super.method_2389(graphics, delta, mouseX, mouseY);
        if (this.filteringBasedOnCraftingMatrixItems) {
            this.renderCraftingMatrixFilteringHighlights(graphics);
        }
    }

    private void renderCraftingMatrixFilteringHighlights(class_332 graphics) {
        for (class_1735 slot : ((AbstractCraftingGridContainerMenu)this.method_17577()).getCraftingMatrixSlots()) {
            if (!slot.method_7681()) continue;
            graphics.method_52706(CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, 18, 18);
        }
    }

    @Override
    protected void method_37432() {
        boolean mayFilterOnCraftingMatrixItems;
        super.method_37432();
        boolean bl = mayFilterOnCraftingMatrixItems = this.field_2787 != null && this.field_2787.field_7871 instanceof class_1731 && CraftingGridScreen.method_25442() && CraftingGridScreen.method_25441();
        if (mayFilterOnCraftingMatrixItems && !this.filteringBasedOnCraftingMatrixItems) {
            this.filteringBasedOnCraftingMatrixItems = true;
            ((AbstractCraftingGridContainerMenu)this.method_17577()).filterBasedOnCraftingMatrixItems();
            if (this.searchField != null) {
                this.searchField.method_1888(false);
            }
        } else if (!mayFilterOnCraftingMatrixItems && this.filteringBasedOnCraftingMatrixItems) {
            ((AbstractCraftingGridContainerMenu)this.method_17577()).stopFilteringBasedOnCraftingMatrixItems();
            this.filteringBasedOnCraftingMatrixItems = false;
            if (this.searchField != null) {
                this.searchField.method_1888(true);
            }
        }
    }

    private void setClearToNetworkButtonActive(boolean active) {
        if (this.clearToNetworkButton == null) {
            return;
        }
        this.clearToNetworkButton.field_22763 = active;
    }

    private CustomButton createClearButton(int x, int y, boolean toPlayerInventory) {
        class_5250 text = IdentifierUtil.createTranslation("gui", "crafting_grid.move." + (toPlayerInventory ? "inventory" : "network"));
        class_304 keyMapping = this.getClearButtonKeyMapping(toPlayerInventory);
        if (keyMapping != null) {
            text.method_27693("\n").method_10852((class_2561)keyMapping.method_16007().method_27661().method_27692(class_124.field_1080));
        }
        class_8666 widgetSprites = toPlayerInventory ? CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES : CLEAR_BUTTON_TO_NETWORK_SPRITES;
        CustomButton button = new CustomButton(x, y, 7, 7, widgetSprites, b -> ((AbstractCraftingGridContainerMenu)this.method_17577()).clear(toPlayerInventory), (class_2561)text);
        button.method_47400(class_7919.method_47407((class_2561)text));
        return button;
    }

    @Nullable
    private class_304 getClearButtonKeyMapping(boolean toPlayerInventory) {
        return toPlayerInventory ? this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory()) : this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork());
    }

    @Nullable
    private class_304 wrapUnbound(@Nullable class_304 keyMapping) {
        return keyMapping == null || keyMapping.method_1415() ? null : keyMapping;
    }

    @Override
    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory())) {
            ((AbstractCraftingGridContainerMenu)this.method_17577()).clear(true);
        } else if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork())) {
            ((AbstractCraftingGridContainerMenu)this.method_17577()).clear(false);
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    public void method_25419() {
        CraftingGridMatrixCloseBehavior behavior = Platform.INSTANCE.getConfig().getCraftingGrid().getCraftingMatrixCloseBehavior();
        if (behavior == CraftingGridMatrixCloseBehavior.CLEAR_TO_NETWORK) {
            ((AbstractCraftingGridContainerMenu)this.method_17577()).clear(false);
        } else if (behavior == CraftingGridMatrixCloseBehavior.CLEAR_TO_INVENTORY) {
            ((AbstractCraftingGridContainerMenu)this.method_17577()).clear(true);
        }
        super.method_25419();
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        boolean hoveredSlotValidForHelp;
        boolean bl = hoveredSlotValidForHelp = this.field_2787 != null && this.field_2787.field_7871 instanceof class_1731 && this.field_2787.method_7681();
        if (((AbstractCraftingGridContainerMenu)this.method_17577()).method_34255().method_7960() && hoveredSlotValidForHelp && !this.filteringBasedOnCraftingMatrixItems) {
            class_1799 stack = this.field_2787.method_7677();
            List lines = this.method_51454(stack);
            List<class_5684> processedLines = Platform.INSTANCE.processTooltipComponents(stack, graphics, x, stack.method_32347(), lines);
            processedLines.add(HelpClientTooltipComponent.create((class_2561)IdentifierUtil.createTranslation("gui", "crafting_grid.press_shift_ctrl_to_only_show_items_used_in_crafting")));
            Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
            return;
        }
        super.method_2380(graphics, x, y);
    }
}

