/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.screen;

import com.refinedmods.refinedstorage.common.grid.GridSearchBox;
import com.refinedmods.refinedstorage.common.support.widget.History;
import com.refinedmods.refinedstorage.common.support.widget.SearchFieldWidget;
import com.refinedmods.refinedstorage.query.lexer.Lexer;
import com.refinedmods.refinedstorage.query.lexer.LexerException;
import com.refinedmods.refinedstorage.query.lexer.LexerTokenMappings;
import com.refinedmods.refinedstorage.query.lexer.Source;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlightedCharacter;
import com.refinedmods.refinedstorage.query.lexer.SyntaxHighlighter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5481;

class GridSearchBoxWidget
extends SearchFieldWidget
implements GridSearchBox {
    private final Set<Consumer<String>> listeners = new HashSet<Consumer<String>>();
    private boolean valid = true;

    GridSearchBoxWidget(class_327 textRenderer, int x, int y, int width, SyntaxHighlighter syntaxHighlighter, History history) {
        super(textRenderer, x, y, width, history);
        this.method_1854((text, firstCharacterIndex) -> this.format(syntaxHighlighter, (String)text));
        this.method_1863(text -> this.listeners.forEach(l -> l.accept(text)));
    }

    private class_5481 format(SyntaxHighlighter syntaxHighlighter, String text) {
        if (!this.valid) {
            return this.invalidText(text);
        }
        Lexer lexer = this.createLexer(text);
        try {
            lexer.scan();
        }
        catch (LexerException e) {
            return this.invalidText(text);
        }
        List<SyntaxHighlightedCharacter> characters = syntaxHighlighter.highlight(text, lexer.getTokens());
        return this.convertCharactersToOrderedText(characters);
    }

    private class_5481 invalidText(String text) {
        return class_5481.method_30747((String)text, (class_2583)class_2583.field_24360.method_27706(class_124.field_1061));
    }

    private class_5481 convertCharactersToOrderedText(List<SyntaxHighlightedCharacter> characters) {
        class_5481 orderedText = class_5481.field_26385;
        for (SyntaxHighlightedCharacter character : characters) {
            orderedText = class_5481.method_30742((class_5481)orderedText, (class_5481)this.convertCharacterToOrderedText(character));
        }
        return orderedText;
    }

    private class_5481 convertCharacterToOrderedText(SyntaxHighlightedCharacter character) {
        class_124 color = class_124.method_533((String)character.getColor());
        return class_5481.method_30747((String)character.getCharacter(), (class_2583)class_2583.field_24360.method_10977(color));
    }

    private Lexer createLexer(String text) {
        return new Lexer(new Source("Grid search box syntax highlighting", text), LexerTokenMappings.DEFAULT_MAPPINGS);
    }

    @Override
    public void addListener(Consumer<String> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
        this.method_1868(valid ? 0xFFFFFF : 0xFF5555);
    }
}

