/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.view.FluidGridResource;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public abstract class AbstractFluidGridResourceRepositoryMapper
implements ResourceRepositoryMapper<GridResource> {
    @Override
    public GridResource apply(ResourceKey resource) {
        FluidResource fluidResource = (FluidResource)resource;
        String name = this.getName(fluidResource);
        String modId = this.getModId(fluidResource);
        String modName = this.getModName(modId);
        Map<GridResourceAttributeKeys, Supplier> attributes = Map.of(GridResourceAttributeKeys.MOD_ID, Suppliers.ofInstance(Set.of(modId)), GridResourceAttributeKeys.MOD_NAME, Suppliers.ofInstance(Set.of(modName)), GridResourceAttributeKeys.TAGS, Suppliers.ofInstance(this.getTags(fluidResource.fluid())), GridResourceAttributeKeys.TOOLTIP, Suppliers.ofInstance(Set.of(this.getTooltip(fluidResource))));
        return new FluidGridResource(fluidResource, name, k -> attributes.getOrDefault(k, Collections::emptySet).get());
    }

    private Set<String> getTags(class_3611 fluid) {
        return class_7923.field_41173.method_29113((Object)fluid).flatMap(arg_0 -> ((class_7922)class_7923.field_41173).method_40264(arg_0)).stream().flatMap(class_6880::method_40228).map(tagKey -> tagKey.comp_327().method_12832()).collect(Collectors.toSet());
    }

    private String getModId(FluidResource fluid) {
        return class_7923.field_41173.method_10221((Object)fluid.fluid()).method_12836();
    }

    protected abstract String getModName(String var1);

    protected abstract String getName(FluidResource var1);

    protected abstract String getTooltip(FluidResource var1);
}

