/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepositoryMapper;
import com.refinedmods.refinedstorage.common.api.grid.GridResourceAttributeKeys;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.view.ItemGridResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemGridResourceRepositoryMapper
implements ResourceRepositoryMapper<GridResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractItemGridResourceRepositoryMapper.class);

    @Override
    public GridResource apply(ResourceKey resource) {
        ItemResource itemResource = (ItemResource)resource;
        class_1792 item = itemResource.item();
        class_1799 itemStack = itemResource.toItemStack();
        String name = item.method_7864(itemStack).getString();
        String modId = this.getModId(itemStack);
        String modName = this.getModName(modId).orElse("");
        Map<GridResourceAttributeKeys, Supplier> attributes = Map.of(GridResourceAttributeKeys.MOD_ID, Suppliers.ofInstance(Set.of(modId)), GridResourceAttributeKeys.MOD_NAME, Suppliers.ofInstance(Set.of(modName)), GridResourceAttributeKeys.TAGS, Suppliers.memoize(() -> this.getTags(item)), GridResourceAttributeKeys.TOOLTIP, Suppliers.memoize(() -> Set.of(this.getTooltip(itemStack))));
        return new ItemGridResource(itemResource, itemStack, name, k -> (Set)attributes.getOrDefault(k, Collections::emptySet).get());
    }

    private String getTooltip(class_1799 itemStack) {
        try {
            return itemStack.method_7950(class_1792.class_9635.field_51353, null, (class_1836)class_1836.field_41071).stream().map(class_2561::getString).collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to get tooltip for item {}", (Object)itemStack, (Object)t);
            return "";
        }
    }

    private Set<String> getTags(class_1792 item) {
        return class_7923.field_41178.method_29113((Object)item).flatMap(arg_0 -> ((class_7922)class_7923.field_41178).method_40264(arg_0)).stream().flatMap(class_6880::method_40228).map(tagKey -> tagKey.comp_327().method_12832()).collect(Collectors.toSet());
    }

    public abstract String getModId(class_1799 var1);

    public abstract Optional<String> getModName(String var1);
}

