/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.grid.view;

import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.grid.view.AbstractGridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResourceAttributeKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGridResource
extends AbstractGridResource<ItemResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemGridResource.class);
    private final int id;
    private final class_1799 itemStack;
    private final ItemResource itemResource;

    public ItemGridResource(ItemResource resource, class_1799 itemStack, String name, Function<GridResourceAttributeKey, Set<String>> attributes) {
        super(resource, name, attributes);
        this.id = class_1792.method_7880((class_1792)resource.item());
        this.itemStack = itemStack;
        this.itemResource = resource;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public ItemResource getItemResource() {
        return this.itemResource;
    }

    @Override
    public int getRegistryId() {
        return this.id;
    }

    @Override
    public List<class_5684> getExtractionHints(class_1799 carriedStack, ResourceRepository<GridResource> repository) {
        long amount = this.getAmount(repository);
        long extractableAmount = Math.min(amount, (long)this.itemStack.method_7914());
        long halfExtractionAmount = extractableAmount == 1L ? 1L : extractableAmount / 2L;
        return List.of(MouseClientTooltipComponent.itemWithDecorations(MouseClientTooltipComponent.Type.LEFT, this.itemStack, extractableAmount == 1L ? null : IdentifierUtil.format(extractableAmount)), MouseClientTooltipComponent.itemWithDecorations(MouseClientTooltipComponent.Type.RIGHT, this.itemStack, halfExtractionAmount == 1L ? null : IdentifierUtil.format(halfExtractionAmount)));
    }

    @Override
    @Nullable
    public ResourceAmount getAutocraftingRequest() {
        return new ResourceAmount(this.itemResource, 1L);
    }

    @Override
    public boolean canExtract(class_1799 carriedStack, ResourceRepository<GridResource> repository) {
        return this.getAmount(repository) > 0L && carriedStack.method_7960();
    }

    @Override
    public void onExtract(GridExtractMode extractMode, boolean cursor, GridExtractionStrategy extractionStrategy) {
        extractionStrategy.onExtract(this.resource, extractMode, cursor);
    }

    @Override
    public void onScroll(GridScrollMode scrollMode, GridScrollingStrategy scrollingStrategy) {
        scrollingStrategy.onScroll(this.resource, scrollMode, -1);
    }

    @Override
    public void render(class_332 graphics, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        try {
            graphics.method_51427(this.itemStack, x, y);
            graphics.method_51432(font, this.itemStack, x, y, null);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to render item {}", (Object)this.itemStack, (Object)t);
        }
    }

    @Override
    public String getDisplayedAmount(ResourceRepository<GridResource> repository) {
        return IdentifierUtil.formatWithUnits(this.getAmount(repository));
    }

    @Override
    public String getAmountInTooltip(ResourceRepository<GridResource> repository) {
        return IdentifierUtil.format(this.getAmount(repository));
    }

    @Override
    public boolean belongsToResourceType(ResourceType resourceType) {
        return resourceType == ResourceTypes.ITEM;
    }

    @Override
    public List<class_2561> getTooltip() {
        class_310 minecraft = class_310.method_1551();
        try {
            return class_437.method_25408((class_310)minecraft, (class_1799)this.itemStack);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to get tooltip for item {}", (Object)this.itemStack, (Object)t);
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<class_5632> getTooltipImage() {
        return this.itemStack.method_32347();
    }
}

