/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.iface;

import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceTransferResult;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProviderImpl;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.iface.ExportedResourcesContainer;
import com.refinedmods.refinedstorage.common.iface.InterfaceContainerMenu;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class InterfaceBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<InterfaceNetworkNode>
implements NetworkNodeExtendedMenuProvider<InterfaceData>,
BlockEntityWithDrops {
    private static final String TAG_EXPORT_ITEMS = "ei";
    private static final int EXPORT_SLOTS = 9;
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer;
    private final FilterWithFuzzyMode filter;
    private final ExportedResourcesContainer exportedResources;
    private final class_1263 exportedResourcesAsContainer;
    private final InterfaceExternalStorageProvider externalStorageProvider;

    public InterfaceBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getInterface(), pos, state, new InterfaceNetworkNode(Platform.INSTANCE.getConfig().getInterface().getEnergyUsage()));
        ((InterfaceNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(InterfaceBlockEntity::getTransferQuota);
        this.upgradeContainer = new UpgradeContainer(1, UpgradeDestinations.INTERFACE, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getInterface().getEnergyUsage();
            ((InterfaceNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            boolean autocrafting = c.has(Items.INSTANCE.getAutocraftingUpgrade());
            ((InterfaceNetworkNode)this.mainNetworkNode).setOnMissingResources(autocrafting ? new InterfaceNetworkNode.AutocraftOnMissingResources() : InterfaceNetworkNode.OnMissingResources.EMPTY);
            this.method_5431();
        });
        this.filter = FilterWithFuzzyMode.create(InterfaceBlockEntity.createFilterContainer(), () -> ((InterfaceBlockEntity)this).method_5431());
        this.exportedResources = InterfaceBlockEntity.createExportedResourcesContainer(this.filter);
        this.exportedResources.setListener(() -> ((InterfaceBlockEntity)this).method_5431());
        ((InterfaceNetworkNode)this.mainNetworkNode).setExportState(this.exportedResources);
        this.exportedResourcesAsContainer = this.exportedResources.toItemContainer();
        this.externalStorageProvider = new InterfaceExternalStorageProviderImpl((InterfaceNetworkNode)this.mainNetworkNode);
    }

    static ResourceContainer createFilterContainer() {
        return new ResourceContainerImpl(9, InterfaceBlockEntity::getTransferQuota, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    static ResourceContainer createFilterContainer(InterfaceData interfaceData) {
        ResourceContainer filterContainer = InterfaceBlockEntity.createFilterContainer();
        ResourceContainerData resourceContainerData = interfaceData.filterContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> filterContainer.set(ii, (ResourceAmount)resource));
        }
        return filterContainer;
    }

    static ExportedResourcesContainer createExportedResourcesContainer(FilterWithFuzzyMode filter) {
        return new ExportedResourcesContainer(9, filter);
    }

    static ResourceContainer createExportedResourcesContainer(InterfaceData interfaceData, FilterWithFuzzyMode filter) {
        ExportedResourcesContainer exportedResourcesContainer = InterfaceBlockEntity.createExportedResourcesContainer(filter);
        ResourceContainerData resourceContainerData = interfaceData.exportedResourcesContainerData();
        for (int i = 0; i < resourceContainerData.resources().size(); ++i) {
            int ii = i;
            resourceContainerData.resources().get(i).ifPresent(resource -> exportedResourcesContainer.set(ii, (ResourceAmount)resource));
        }
        return exportedResourcesContainer;
    }

    static long getTransferQuota(ResourceKey resource) {
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            return platformResource.getInterfaceExportLimit();
        }
        return 0L;
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_EXPORT_ITEMS, (class_2520)this.exportedResources.toTag(provider));
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_EXPORT_ITEMS)) {
            this.exportedResources.fromTag(tag.method_10562(TAG_EXPORT_ITEMS), provider);
        }
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void clearFilters() {
        this.filter.getFilterContainer().clear();
    }

    void setFilters(List<ResourceAmount> filters) {
        for (int i = 0; i < filters.size(); ++i) {
            this.filter.getFilterContainer().set(i, filters.get(i));
        }
    }

    public ExportedResourcesContainer getExportedResources() {
        return this.exportedResources;
    }

    public class_1263 getExportedResourcesAsContainer() {
        return this.exportedResourcesAsContainer;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new InterfaceContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.exportedResources, this.exportedResourcesAsContainer, this.upgradeContainer, this.getExportingIndicators());
    }

    private ExportingIndicators getExportingIndicators() {
        return new ExportingIndicators(this.filter.getFilterContainer(), i -> this.toExportingIndicator(((InterfaceNetworkNode)this.mainNetworkNode).getLastResult(i)), true);
    }

    private ExportingIndicator toExportingIndicator(@Nullable InterfaceTransferResult result) {
        InterfaceTransferResult interfaceTransferResult = result;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STORAGE_DOES_NOT_ACCEPT_RESOURCE", "RESOURCE_MISSING", "AUTOCRAFTING_STARTED", "AUTOCRAFTING_MISSING_RESOURCES"}, (InterfaceTransferResult)interfaceTransferResult, n)) {
            case 0 -> ExportingIndicator.DESTINATION_DOES_NOT_ACCEPT_RESOURCE;
            case 1 -> ExportingIndicator.RESOURCE_MISSING;
            case 2 -> ExportingIndicator.AUTOCRAFTING_WAS_STARTED;
            case 3 -> ExportingIndicator.AUTOCRAFTING_MISSING_RESOURCES;
            default -> ExportingIndicator.NONE;
        };
    }

    @Override
    public InterfaceData getMenuData() {
        return new InterfaceData(ResourceContainerData.of(this.filter.getFilterContainer()), ResourceContainerData.of(this.exportedResources), this.getExportingIndicators().getAll());
    }

    @Override
    public class_9142<class_9129, InterfaceData> getMenuCodec() {
        return InterfaceData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.INTERFACE);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.exportedResourcesAsContainer.method_5439(); ++i) {
            drops.add((Object)this.exportedResourcesAsContainer.method_5438(i));
        }
        drops.addAll(this.upgradeContainer.getDrops());
        return drops;
    }

    InterfaceExternalStorageProvider getExternalStorageProvider() {
        return this.externalStorageProvider;
    }

    InterfaceNetworkNode getInterface() {
        return (InterfaceNetworkNode)this.mainNetworkNode;
    }
}

