/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.iface;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.iface.externalstorage.InterfaceExternalStorageProvider;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlockEntity;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class InterfaceProxyExternalStorageProvider
implements InterfaceExternalStorageProvider {
    private final class_1937 level;
    private final class_2338 pos;

    public InterfaceProxyExternalStorageProvider(class_1937 level, class_2338 pos) {
        this.level = level;
        this.pos = pos;
    }

    private Optional<InterfaceBlockEntity> tryGetInterface() {
        class_2586 class_25862 = this.level.method_8321(this.pos);
        if (class_25862 instanceof InterfaceBlockEntity) {
            InterfaceBlockEntity blockEntity = (InterfaceBlockEntity)class_25862;
            return Optional.of(blockEntity);
        }
        return Optional.empty();
    }

    private Optional<InterfaceExternalStorageProvider> tryGetProvider() {
        return this.tryGetInterface().map(InterfaceBlockEntity::getExternalStorageProvider);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.tryGetProvider().map(provider -> provider.extract(resource, amount, action, actor)).orElse(0L);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.tryGetProvider().map(provider -> provider.insert(resource, amount, action, actor)).orElse(0L);
    }

    @Override
    public Iterator<ResourceAmount> iterator() {
        return this.tryGetProvider().map(ExternalStorageProvider::iterator).orElse(Collections.emptyIterator());
    }

    @Override
    @Nullable
    public InterfaceNetworkNode getInterface() {
        return this.tryGetInterface().map(InterfaceBlockEntity::getInterface).orElse(null);
    }
}

