/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.importer;

import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.importer.ImporterContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporterBlockEntity
extends AbstractCableLikeBlockEntity<ImporterNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractImporterBlockEntity.class);
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_UPGRADES = "upgr";
    private final FilterWithFuzzyMode filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractImporterBlockEntity)this).method_5431(), this::setFilters);
    private final UpgradeContainer upgradeContainer;

    protected AbstractImporterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getImporter(), pos, state, new ImporterNetworkNode(Platform.INSTANCE.getConfig().getImporter().getEnergyUsage()));
        ((ImporterNetworkNode)this.mainNetworkNode).setNormalizer(this.filter.createNormalizer());
        this.upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.IMPORTER, (c, upgradeEnergyUsage) -> {
            long baseEnergyUsage = Platform.INSTANCE.getConfig().getImporter().getEnergyUsage();
            ((ImporterNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
            this.method_5431();
            class_1937 patt0$temp = this.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                this.initialize(serverLevel);
            }
        });
        this.ticker = this.upgradeContainer.getTicker();
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    @Override
    protected void initialize(class_3218 level, class_2350 direction) {
        super.initialize(level, direction);
        ImporterTransferStrategy strategy = this.createStrategy(level, direction);
        LOGGER.debug("Initialized importer at {} with strategy {}", (Object)this.field_11867, (Object)strategy);
        ((ImporterNetworkNode)this.mainNetworkNode).setTransferStrategy(strategy);
    }

    private ImporterTransferStrategy createStrategy(class_3218 serverLevel, class_2350 direction) {
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        List<ImporterTransferStrategyFactory> factories = RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll();
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, this.upgradeContainer)).toList());
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((ImporterNetworkNode)this.mainNetworkNode).getFilterMode()));
        this.filter.save(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_FILTER_MODE)) {
            ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.method_10550(TAG_FILTER_MODE)));
        }
        this.filter.load(tag, provider);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    FilterMode getFilterMode() {
        return ((ImporterNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((ImporterNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.IMPORTER);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new ImporterContainerMenu(syncId, player, this, this.filter.getFilterContainer(), this.upgradeContainer, p -> class_1263.method_49105((class_2586)this, (class_1657)p));
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

