/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.BlockEntityProvider;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.networking.AbstractCableBlockEntity;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.AbstractBlockEntityTicker;
import com.refinedmods.refinedstorage.common.support.AbstractColoredBlock;
import com.refinedmods.refinedstorage.common.support.BaseBlockItem;
import com.refinedmods.refinedstorage.common.support.CableShapes;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.NetworkNodeBlockItem;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeBlockEntityTicker;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_5250;
import net.minecraft.class_5558;

public class CableBlock
extends AbstractColoredBlock<CableBlock>
implements ColorableBlock<CableBlock, BaseBlockItem>,
class_3737,
class_2343 {
    private static final AbstractBlockEntityTicker<AbstractCableBlockEntity> TICKER = new NetworkNodeBlockEntityTicker(BlockEntities.INSTANCE::getCable);
    private static final class_2561 HELP = IdentifierUtil.createTranslation("item", "cable.help");
    private final BlockEntityProvider<AbstractCableBlockEntity> blockEntityProvider;

    public CableBlock(class_1767 color, class_5250 name, BlockEntityProvider<AbstractCableBlockEntity> blockEntityProvider) {
        super(BlockConstants.CABLE_PROPERTIES, color, name);
        this.blockEntityProvider = blockEntityProvider;
    }

    @Override
    protected class_2680 getDefaultState() {
        return (class_2680)super.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
    }

    public boolean method_9579(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) == false;
    }

    public class_3610 method_9545(class_2680 state) {
        return Boolean.TRUE.equals(state.method_11654((class_2769)class_2741.field_12508)) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12508});
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof AbstractCableBlockEntity) {
            AbstractCableBlockEntity cable = (AbstractCableBlockEntity)blockEntity;
            cable.updateConnections();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                PlatformUtil.sendBlockUpdateToClient((class_1937)serverLevel, pos);
            }
        }
        if (level.method_8608()) {
            Platform.INSTANCE.requestModelDataUpdateOnClient(level, pos, false);
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof AbstractCableBlockEntity)) {
            return class_259.method_1077();
        }
        AbstractCableBlockEntity cable = (AbstractCableBlockEntity)blockEntity;
        CableConnections connections = cable.getConnections();
        return CableShapes.getShape(connections);
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof AbstractCableBlockEntity) {
            AbstractCableBlockEntity cable = (AbstractCableBlockEntity)blockEntity;
            cable.updateConnections();
            PlatformUtil.sendBlockUpdateToClient(level, pos);
        }
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.blockEntityProvider.create(pos, state);
    }

    @Override
    public BlockColorMap<CableBlock, BaseBlockItem> getBlockColorMap() {
        return Blocks.INSTANCE.getCable();
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> type) {
        return TICKER.get(level, type);
    }

    @Override
    public BaseBlockItem createBlockItem() {
        return new NetworkNodeBlockItem(this, HELP);
    }
}

