/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.networking.NetworkCardInventory;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkReceiverKey;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterState;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTransmitterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<NetworkTransmitterData>,
BlockEntityWithDrops {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkTransmitterBlockEntity.class);
    private static final NetworkTransmitterData INACTIVE = NetworkTransmitterData.message(false, (class_2561)IdentifierUtil.createTranslation("gui", "network_transmitter.status.inactive"));
    private static final NetworkTransmitterData MISSING_NETWORK_CARD = NetworkTransmitterData.error((class_2561)IdentifierUtil.createTranslation("gui", "network_transmitter.status.missing_network_card").method_27692(class_124.field_1079));
    private static final NetworkTransmitterData RECEIVER_UNREACHABLE = NetworkTransmitterData.error((class_2561)IdentifierUtil.createTranslation("gui", "network_transmitter.status.receiver_unreachable").method_27692(class_124.field_1079));
    private static final String TAG_NETWORK_CARD_INVENTORY = "nc";
    private final NetworkCardInventory networkCardInventory = new NetworkCardInventory();
    private final RateLimiter stateChangeRateLimiter = RateLimiter.create((double)1.0);
    private final RateLimiter networkRebuildRetryRateLimiter = RateLimiter.create((double)0.2);
    @Nullable
    private NetworkReceiverKey receiverKey;

    public NetworkTransmitterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getNetworkTransmitter(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getNetworkTransmitter().getEnergyUsage()));
        this.networkCardInventory.method_5489(container -> {
            this.updateReceiverLocation();
            if (this.field_11863 != null) {
                LOGGER.debug("Network card was changed at {}, sending network update", (Object)this.field_11867);
                this.method_5431();
                this.containers.update(this.field_11863);
            }
        });
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(SimpleNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new ColoredConnectionStrategy(() -> ((NetworkTransmitterBlockEntity)this).method_11010(), this.method_11016()){

            @Override
            public void addOutgoingConnections(ConnectionSink sink) {
                super.addOutgoingConnections(sink);
                if (NetworkTransmitterBlockEntity.this.receiverKey != null && ((SimpleNetworkNode)NetworkTransmitterBlockEntity.this.mainNetworkNode).isActive()) {
                    sink.tryConnect(NetworkTransmitterBlockEntity.this.receiverKey.pos(), NetworkReceiverBlock.class);
                }
            }
        }).build();
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.containers.update(this.field_11863);
    }

    public void updateStateInLevel(class_2680 state) {
        NetworkTransmitterState newState;
        NetworkTransmitterState currentState = (NetworkTransmitterState)((Object)state.method_11654(NetworkTransmitterBlock.STATE));
        if (currentState != (newState = this.calculateState()) && this.field_11863 != null && this.stateChangeRateLimiter.tryAcquire()) {
            LOGGER.debug("Updating network transmitter at {} from {} to {}", new Object[]{this.field_11867, currentState, newState});
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657(NetworkTransmitterBlock.STATE, (Comparable)((Object)newState)));
        }
    }

    private NetworkTransmitterState calculateState() {
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive()) {
            return NetworkTransmitterState.INACTIVE;
        }
        if (this.receiverKey == null) {
            return NetworkTransmitterState.ERROR;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return NetworkTransmitterState.ERROR;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(network, this.receiverKey);
        return receiverFound ? NetworkTransmitterState.ACTIVE : NetworkTransmitterState.ERROR;
    }

    NetworkTransmitterData getStatus() {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive() || network == null || this.field_11863 == null) {
            return INACTIVE;
        }
        if (this.receiverKey == null) {
            return MISSING_NETWORK_CARD;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(network, this.receiverKey);
        if (!receiverFound) {
            return RECEIVER_UNREACHABLE;
        }
        boolean showDistance = this.field_11863.method_27983() == this.receiverKey.pos().comp_2207();
        class_5250 message = showDistance ? IdentifierUtil.createTranslation("gui", "network_transmitter.status.transmitting", this.receiverKey.getDistance(this.field_11867)) : this.receiverKey.getDimensionName();
        return NetworkTransmitterData.message(true, (class_2561)message);
    }

    @Override
    public void doWork() {
        super.doWork();
        if (!((SimpleNetworkNode)this.mainNetworkNode).isActive() || ((SimpleNetworkNode)this.mainNetworkNode).getNetwork() == null || this.receiverKey == null) {
            return;
        }
        boolean receiverFound = NetworkTransmitterBlockEntity.isReceiverFoundInNetwork(((SimpleNetworkNode)this.mainNetworkNode).getNetwork(), this.receiverKey);
        if (!receiverFound && this.networkRebuildRetryRateLimiter.tryAcquire()) {
            this.tryReconnectingWithReceiver();
        }
    }

    private void tryReconnectingWithReceiver() {
        LOGGER.debug("Receiver {} was not found in network for transmitter at {}, retrying and sending network update", (Object)this.receiverKey, (Object)this.field_11867);
        this.containers.update(this.field_11863);
    }

    private static boolean isReceiverFoundInNetwork(Network network, NetworkReceiverKey key) {
        return network.getComponent(GraphNetworkComponent.class).getContainer(key) != null;
    }

    class_1263 getNetworkCardInventory() {
        return this.networkCardInventory;
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_NETWORK_CARD_INVENTORY, (class_2520)ContainerUtil.write((class_1263)this.networkCardInventory, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545(TAG_NETWORK_CARD_INVENTORY)) {
            ContainerUtil.read(tag.method_10562(TAG_NETWORK_CARD_INVENTORY), (class_1263)this.networkCardInventory, provider);
        }
        this.updateReceiverLocation();
    }

    private void updateReceiverLocation() {
        this.receiverKey = this.networkCardInventory.getReceiverLocation().map(NetworkReceiverKey::new).orElse(null);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new NetworkTransmitterContainerMenu(syncId, inventory, this);
    }

    @Override
    public NetworkTransmitterData getMenuData() {
        return this.getStatus();
    }

    @Override
    public class_9142<class_9129, NetworkTransmitterData> getMenuCodec() {
        return NetworkTransmitterData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.NETWORK_TRANSMITTER);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        return class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{this.networkCardInventory.getNetworkCard()});
    }
}

