/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.networking.NetworkCardInventory;
import com.refinedmods.refinedstorage.common.networking.NetworkCardItem;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.NetworkTransmitterData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class NetworkTransmitterContainerMenu
extends AbstractBaseContainerMenu {
    @Nullable
    private final NetworkTransmitterBlockEntity blockEntity;
    private final class_1657 player;
    private final RateLimiter statusUpdateRateLimiter = RateLimiter.create((double)2.0);
    private NetworkTransmitterData status;

    NetworkTransmitterContainerMenu(int syncId, class_1661 playerInventory, NetworkTransmitterBlockEntity blockEntity) {
        super(Menus.INSTANCE.getNetworkTransmitter(), syncId);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.blockEntity = blockEntity;
        this.player = playerInventory.field_7546;
        this.status = blockEntity.getStatus();
        this.addSlots(playerInventory, blockEntity.getNetworkCardInventory());
    }

    public NetworkTransmitterContainerMenu(int syncId, class_1661 playerInventory, NetworkTransmitterData status) {
        super(Menus.INSTANCE.getNetworkTransmitter(), syncId);
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.blockEntity = null;
        this.player = playerInventory.field_7546;
        this.status = status;
        this.addSlots(playerInventory, (class_1263)new NetworkCardInventory());
    }

    public void method_7623() {
        class_1657 class_16572;
        super.method_7623();
        if (this.blockEntity == null || !((class_16572 = this.player) instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        if (!this.statusUpdateRateLimiter.tryAcquire()) {
            return;
        }
        NetworkTransmitterData newStatus = this.blockEntity.getStatus();
        if (newStatus.equals(this.status)) {
            return;
        }
        this.updateStatus(serverPlayer, newStatus);
    }

    public boolean method_7597(class_1657 p) {
        if (this.blockEntity == null) {
            return true;
        }
        return class_1263.method_49105((class_2586)this.blockEntity, (class_1657)p);
    }

    private void updateStatus(class_3222 serverPlayer, NetworkTransmitterData newStatus) {
        this.status = newStatus;
        S2CPackets.sendNetworkTransmitterStatus(serverPlayer, newStatus);
    }

    private void addSlots(class_1661 playerInventory, class_1263 networkCardInventory) {
        this.addPlayerInventory(playerInventory, 8, 55);
        this.method_7621(new ValidatedSlot(networkCardInventory, 0, 8, 20, stack -> {
            NetworkCardItem networkCardItem;
            class_1792 patt0$temp = stack.method_7909();
            return patt0$temp instanceof NetworkCardItem && (networkCardItem = (NetworkCardItem)patt0$temp).isActive((class_1799)stack);
        }));
        this.transferManager.addBiTransfer((class_1263)playerInventory, networkCardInventory);
    }

    NetworkTransmitterData getStatus() {
        return this.status;
    }

    public void setStatus(NetworkTransmitterData status) {
        this.status = status;
    }
}

