/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayComponentType;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayInputNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.relay.RelayOutputNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.networking.RelayContainerMenu;
import com.refinedmods.refinedstorage.common.networking.RelayInputConnectionStrategy;
import com.refinedmods.refinedstorage.common.networking.RelayOutputConnectionStrategy;
import com.refinedmods.refinedstorage.common.storage.AccessModeSettings;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class RelayBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<RelayInputNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final String TAG_PASS_THROUGH = "passthrough";
    private static final String TAG_PASS_ENERGY = "passenergy";
    private static final String TAG_PASS_SECURITY = "passsecurity";
    private static final String TAG_PASS_STORAGE = "passstorage";
    private static final String TAG_PASS_AUTOCRAFTING = "passautocrafting";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_ACCESS_MODE = "am";
    private static final String TAG_INSERT_PRIORITY = "pri";
    private static final String TAG_EXTRACT_PRIORITY = "epri";
    private final FilterWithFuzzyMode filter;
    private final RelayOutputNetworkNode outputNode;
    private boolean passThrough = true;
    private FilterMode filterMode = FilterMode.BLOCK;
    private AccessMode accessMode = AccessMode.INSERT_EXTRACT;
    private int insertPriority = 0;
    private int extractPriority = 0;

    public RelayBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getRelay(), pos, state, new RelayInputNetworkNode(Platform.INSTANCE.getConfig().getRelay().getInputNetworkEnergyUsage()));
        this.outputNode = new RelayOutputNetworkNode(Platform.INSTANCE.getConfig().getRelay().getOutputNetworkEnergyUsage());
        ((RelayInputNetworkNode)this.mainNetworkNode).setOutputNode(this.outputNode);
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((RelayBlockEntity)this).method_5431(), this::setFilters);
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterNormalizer(this.filter.createNormalizer());
        this.containers.addContainer(RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, this.outputNode).name("output").connectionStrategy(new RelayOutputConnectionStrategy(this)).build());
        this.setRedstoneMode(RedstoneMode.LOW);
    }

    @Override
    public void doWork() {
        super.doWork();
        this.ticker.tick(this.outputNode);
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        boolean wasActive = ((RelayInputNetworkNode)this.mainNetworkNode).isActive();
        ((RelayInputNetworkNode)this.mainNetworkNode).setActive(false);
        this.filter.setFuzzyMode(fuzzyMode);
        ((RelayInputNetworkNode)this.mainNetworkNode).setActive(wasActive);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilters(filters);
        this.method_5431();
    }

    int getInsertPriority() {
        return this.insertPriority;
    }

    void setInsertPriority(int insertPriority) {
        this.insertPriority = insertPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setInsertPriority(insertPriority);
        this.method_5431();
    }

    int getExtractPriority() {
        return this.extractPriority;
    }

    void setExtractPriority(int extractPriority) {
        this.extractPriority = extractPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setExtractPriority(extractPriority);
        this.method_5431();
    }

    AccessMode getAccessMode() {
        return this.accessMode;
    }

    void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        ((RelayInputNetworkNode)this.mainNetworkNode).setAccessMode(accessMode);
        this.method_5431();
    }

    FilterMode getFilterMode() {
        return this.filterMode;
    }

    void setFilterMode(FilterMode filterMode) {
        this.filterMode = filterMode;
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterMode(filterMode);
        this.method_5431();
    }

    boolean isPassEnergy() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.ENERGY);
    }

    void setPassEnergy(boolean passEnergy) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.ENERGY, passEnergy);
        this.method_5431();
    }

    boolean isPassStorage() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.STORAGE);
    }

    void setPassStorage(boolean passStorage) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.STORAGE, passStorage);
        this.method_5431();
    }

    boolean isPassSecurity() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.SECURITY);
    }

    void setPassSecurity(boolean passSecurity) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.SECURITY, passSecurity);
        this.method_5431();
    }

    boolean isPassAutocrafting() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.AUTOCRAFTING);
    }

    void setPassAutocrafting(boolean passAutocrafting) {
        ((RelayInputNetworkNode)this.mainNetworkNode).updateComponentType(RelayComponentType.AUTOCRAFTING, passAutocrafting);
        this.method_5431();
    }

    boolean isPassThrough() {
        return this.passThrough;
    }

    void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
        ((RelayInputNetworkNode)this.mainNetworkNode).setComponentTypes(Set.of());
        this.method_5431();
        this.containers.update(this.field_11863);
    }

    boolean isActiveInternal() {
        return ((RelayInputNetworkNode)this.mainNetworkNode).isActive();
    }

    class_2350 getDirectionInternal() {
        return Objects.requireNonNull(AbstractDirectionalBlock.tryExtractDirection(this.method_11010()));
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        this.outputNode.setActive(newActive);
        this.containers.update(this.field_11863);
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(RelayInputNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).name("input").connectionStrategy(new RelayInputConnectionStrategy(this)).build();
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.RELAY);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new RelayContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        tag.method_10569(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(this.filterMode));
        tag.method_10556(TAG_PASS_THROUGH, this.passThrough);
        tag.method_10556(TAG_PASS_ENERGY, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.ENERGY));
        tag.method_10556(TAG_PASS_STORAGE, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.STORAGE));
        tag.method_10556(TAG_PASS_SECURITY, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.SECURITY));
        tag.method_10556(TAG_PASS_AUTOCRAFTING, ((RelayInputNetworkNode)this.mainNetworkNode).hasComponentType(RelayComponentType.AUTOCRAFTING));
        tag.method_10569(TAG_ACCESS_MODE, AccessModeSettings.getAccessMode(this.accessMode));
        tag.method_10569(TAG_INSERT_PRIORITY, this.insertPriority);
        tag.method_10569(TAG_EXTRACT_PRIORITY, this.extractPriority);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        if (tag.method_10545(TAG_FILTER_MODE)) {
            this.filterMode = FilterModeSettings.getFilterMode(tag.method_10550(TAG_FILTER_MODE));
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setFilterMode(this.filterMode);
        if (tag.method_10545(TAG_PASS_THROUGH)) {
            this.passThrough = tag.method_10577(TAG_PASS_THROUGH);
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setComponentTypes(this.getComponentTypes(tag));
        if (tag.method_10545(TAG_ACCESS_MODE)) {
            this.accessMode = AccessModeSettings.getAccessMode(tag.method_10550(TAG_ACCESS_MODE));
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setAccessMode(this.accessMode);
        if (tag.method_10545(TAG_INSERT_PRIORITY)) {
            this.insertPriority = tag.method_10550(TAG_INSERT_PRIORITY);
        }
        ((RelayInputNetworkNode)this.mainNetworkNode).setInsertPriority(this.insertPriority);
        this.extractPriority = tag.method_10545(TAG_EXTRACT_PRIORITY) ? tag.method_10550(TAG_EXTRACT_PRIORITY) : this.insertPriority;
        ((RelayInputNetworkNode)this.mainNetworkNode).setExtractPriority(this.extractPriority);
    }

    private Set<RelayComponentType<?>> getComponentTypes(class_2487 tag) {
        HashSet types = new HashSet();
        if (tag.method_10577(TAG_PASS_ENERGY)) {
            types.add(RelayComponentType.ENERGY);
        }
        if (tag.method_10577(TAG_PASS_SECURITY)) {
            types.add(RelayComponentType.SECURITY);
        }
        if (tag.method_10577(TAG_PASS_STORAGE)) {
            types.add(RelayComponentType.STORAGE);
        }
        if (tag.method_10577(TAG_PASS_AUTOCRAFTING)) {
            types.add(RelayComponentType.AUTOCRAFTING);
        }
        return types;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

