/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterConnectionStrategy;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterContainerMenu;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterData;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;

public class WirelessTransmitterBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<WirelessTransmitterData>,
BlockEntityWithDrops {
    private static final String TAG_UPGRADES = "upgr";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.WIRELESS_TRANSMITTER, (c, upgradeEnergyUsage) -> {
        long baseUsage = Platform.INSTANCE.getConfig().getWirelessTransmitter().getEnergyUsage();
        ((SimpleNetworkNode)this.mainNetworkNode).setEnergyUsage(baseUsage + upgradeEnergyUsage);
        this.method_5431();
    });

    public WirelessTransmitterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getWirelessTransmitter(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getWirelessTransmitter().getEnergyUsage()));
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(SimpleNetworkNode networkNode) {
        return new WirelessTransmitterNetworkNodeContainer(this, networkNode, "main", new WirelessTransmitterConnectionStrategy(() -> ((WirelessTransmitterBlockEntity)this).method_11010(), this.method_11016()));
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.WIRELESS_TRANSMITTER);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new WirelessTransmitterContainerMenu(syncId, inventory, this, this.upgradeContainer);
    }

    @Override
    public WirelessTransmitterData getMenuData() {
        return new WirelessTransmitterData(this.getRange(), this.isActive());
    }

    @Override
    public class_9142<class_9129, WirelessTransmitterData> getMenuCodec() {
        return WirelessTransmitterData.STREAM_CODEC;
    }

    int getRange() {
        return RefinedStorageApi.INSTANCE.getWirelessTransmitterRangeModifier().modifyRange(this.upgradeContainer, 0);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.upgradeContainer.method_5439(); ++i) {
            drops.add((Object)this.upgradeContainer.method_5438(i));
        }
        return drops;
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    boolean isActive() {
        return ((SimpleNetworkNode)this.mainNetworkNode).isActive();
    }
}

