/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.networking;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterBlockEntity;
import com.refinedmods.refinedstorage.common.networking.WirelessTransmitterData;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class WirelessTransmitterContainerMenu
extends AbstractBaseContainerMenu {
    private final RateLimiter rangeRateLimiter = RateLimiter.create((double)4.0);
    @Nullable
    private final WirelessTransmitterBlockEntity wirelessTransmitter;
    private final class_1657 player;
    private int range;
    private boolean active;

    public WirelessTransmitterContainerMenu(int syncId, class_1661 playerInventory, WirelessTransmitterData data) {
        super(Menus.INSTANCE.getWirelessTransmitter(), syncId);
        this.addSlots(playerInventory, new UpgradeContainer(UpgradeDestinations.WIRELESS_TRANSMITTER));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.range = data.range();
        this.active = data.active();
        this.wirelessTransmitter = null;
        this.player = playerInventory.field_7546;
    }

    WirelessTransmitterContainerMenu(int syncId, class_1661 playerInventory, WirelessTransmitterBlockEntity wirelessTransmitter, UpgradeContainer upgradeContainer) {
        super(Menus.INSTANCE.getWirelessTransmitter(), syncId);
        this.addSlots(playerInventory, upgradeContainer);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, wirelessTransmitter::getRedstoneMode, wirelessTransmitter::setRedstoneMode));
        this.range = wirelessTransmitter.getRange();
        this.active = wirelessTransmitter.isActive();
        this.wirelessTransmitter = wirelessTransmitter;
        this.player = playerInventory.field_7546;
    }

    private void addSlots(class_1661 playerInventory, UpgradeContainer upgradeContainer) {
        this.addPlayerInventory(playerInventory, 8, 55);
        for (int i = 0; i < upgradeContainer.method_5439(); ++i) {
            this.method_7621(new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
        }
        this.transferManager.addBiTransfer((class_1263)playerInventory, (class_1263)upgradeContainer);
    }

    public void method_7623() {
        boolean changed;
        super.method_7623();
        if (this.wirelessTransmitter == null) {
            return;
        }
        int newRange = this.wirelessTransmitter.getRange();
        boolean newActive = this.wirelessTransmitter.isActive();
        boolean bl = changed = this.range != newRange || this.active != newActive;
        if (changed && this.rangeRateLimiter.tryAcquire()) {
            this.range = newRange;
            this.active = newActive;
            S2CPackets.sendWirelessTransmitterData((class_3222)this.player, this.range, this.active);
        }
    }

    public boolean method_7597(class_1657 p) {
        if (this.wirelessTransmitter == null) {
            return true;
        }
        return class_1263.method_49105((class_2586)this.wirelessTransmitter, (class_1657)p);
    }

    int getRange() {
        return this.range;
    }

    boolean isActive() {
        return this.active;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

