/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.security.SecurityPolicyContainerItem;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.SecurityCardPermissions;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

abstract class AbstractSecurityCardItem<T>
extends class_1792
implements SecurityPolicyContainerItem {
    protected AbstractSecurityCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 flag) {
        super.method_7851(stack, context, lines, flag);
        this.getPolicy(stack).ifPresent(policy -> this.appendHoverText(lines, (SecurityPolicy)policy, this.getDirtyPermissions(stack)));
    }

    private void appendHoverText(List<class_2561> lines, SecurityPolicy policy, Set<PlatformPermission> dirtyPermissions) {
        List<PlatformPermission> allPermissions = RefinedStorageApi.INSTANCE.getPermissionRegistry().getAll();
        allPermissions.forEach(permission -> {
            boolean allowed = policy.isAllowed((Permission)permission);
            boolean dirty = dirtyPermissions.contains(permission);
            class_2583 style = class_2583.field_24360.method_10977(allowed ? class_124.field_1060 : class_124.field_1061).method_10978(Boolean.valueOf(dirty));
            class_5250 permissionTooltip = class_2561.method_43470((String)(allowed ? "\u2713 " : "\u274c ")).method_10852(permission.getName()).method_27693(dirty ? " (*)" : "").method_27696(style);
            lines.add((class_2561)permissionTooltip);
        });
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.doUse(hand, serverPlayer, stack);
        }
        return class_1271.method_22428((Object)stack);
    }

    private void doUse(class_1268 hand, class_3222 player, class_1799 stack) {
        if (player.method_18276()) {
            this.clearConfiguration(player, stack);
            return;
        }
        this.getPolicy(stack).ifPresent(policy -> {
            Set<PlatformPermission> dirtyPermissions = this.getDirtyPermissions(stack);
            Platform.INSTANCE.getMenuOpener().openMenu(player, this.createMenuProvider(player.field_13995, RefinedStorageApi.INSTANCE.createInventorySlotReference((class_1657)player, hand), (SecurityPolicy)policy, dirtyPermissions, stack));
        });
    }

    private void clearConfiguration(class_3222 player, class_1799 stack) {
        stack.method_57381(DataComponents.INSTANCE.getSecurityCardPermissions());
        player.method_43496((class_2561)IdentifierUtil.createTranslation("item", "security_card.cleared_configuration"));
    }

    abstract AbstractSecurityCardExtendedMenuProvider<T> createMenuProvider(MinecraftServer var1, SlotReference var2, SecurityPolicy var3, Set<PlatformPermission> var4, class_1799 var5);

    @Override
    public Optional<SecurityPolicy> getPolicy(class_1799 stack) {
        if (!this.isValid(stack)) {
            return Optional.empty();
        }
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.method_57824(DataComponents.INSTANCE.getSecurityCardPermissions());
        if (permissions == null) {
            return Optional.of(RefinedStorageApi.INSTANCE.createDefaultSecurityPolicy());
        }
        return Optional.of(this.createPolicy(permissions));
    }

    private SecurityPolicy createPolicy(SecurityCardPermissions permissions) {
        HashSet<Permission> allowedPermissions = new HashSet<Permission>();
        for (PlatformPermission permission : RefinedStorageApi.INSTANCE.getPermissionRegistry().getAll()) {
            boolean isAllowedByDefault;
            boolean dirty = permissions.isDirty(permission);
            boolean didExplicitlyAllow = dirty && permissions.isAllowed(permission);
            boolean bl = isAllowedByDefault = !dirty && permission.isAllowedByDefault();
            if (!didExplicitlyAllow && !isAllowedByDefault) continue;
            allowedPermissions.add(permission);
        }
        return new SecurityPolicy(allowedPermissions);
    }

    @Override
    public boolean isValid(class_1799 stack) {
        return true;
    }

    Set<PlatformPermission> getDirtyPermissions(class_1799 stack) {
        return ((SecurityCardPermissions)stack.method_57825(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY)).permissions().keySet();
    }

    void setPermission(class_1799 stack, PlatformPermission permission, boolean allowed) {
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.method_57825(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY);
        stack.method_57379(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)permissions.withPermission(permission, allowed));
    }

    void resetPermission(class_1799 stack, PlatformPermission permission) {
        SecurityCardPermissions permissions = (SecurityCardPermissions)stack.method_57825(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)SecurityCardPermissions.EMPTY);
        stack.method_57379(DataComponents.INSTANCE.getSecurityCardPermissions(), (Object)permissions.forgetPermission(permission));
    }
}

