/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardContainerMenu;
import com.refinedmods.refinedstorage.common.security.SecurityCardData;
import com.refinedmods.refinedstorage.common.support.stretching.AbstractStretchingScreen;
import com.refinedmods.refinedstorage.common.support.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public abstract class AbstractSecurityCardScreen<T extends AbstractSecurityCardContainerMenu>
extends AbstractStretchingScreen<T> {
    private static final class_2960 TEXTURE = IdentifierUtil.createIdentifier("textures/gui/security_card.png");
    private static final int RESET_BUTTON_WIDTH = 40;
    private static final int RESET_BUTTON_RIGHT_PADDING = 16;
    private static final class_2561 RESET_TITLE = IdentifierUtil.createTranslation("gui", "security_card.permission.reset");
    private static final class_2561 MODIFIED_TITLE = IdentifierUtil.createTranslation("gui", "security_card.permission.modified").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1054));
    private final List<Permission> permissions = new ArrayList<Permission>();

    protected AbstractSecurityCardScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
        this.field_25270 = 97;
        this.field_2792 = 193;
        this.field_2779 = 176;
    }

    @Override
    protected void init(int rows) {
        this.permissions.clear();
        List<SecurityCardData.Permission> menuPermissions = ((AbstractSecurityCardContainerMenu)this.method_17577()).getPermissions();
        for (int i = 0; i < menuPermissions.size(); ++i) {
            Permission permission = this.createPermission(menuPermissions.get(i), i, rows);
            this.method_25429((class_364)permission.checkbox);
            this.method_25429((class_364)permission.resetButton);
            this.permissions.add(permission);
        }
        this.updateScrollbar(this.permissions.size());
    }

    private Permission createPermission(SecurityCardData.Permission menuPermission, int index, int rows) {
        int y = this.getPermissionY(index);
        boolean visible = this.isPermissionVisible(rows, y);
        CheckboxWidget checkbox = this.createPermissionCheckbox(menuPermission, y, visible);
        class_4185 resetButton = this.createPermissionResetButton(menuPermission, checkbox, y, visible);
        checkbox.setOnPressed((c, selected) -> this.updatePermission(menuPermission, resetButton, c, selected));
        return new Permission(checkbox, resetButton);
    }

    private CheckboxWidget createPermissionCheckbox(SecurityCardData.Permission menuPermission, int y, boolean visible) {
        CheckboxWidget checkbox = new CheckboxWidget(this.field_2776 + 10, y, this.getPermissionName(menuPermission), this.field_22793, menuPermission.allowed(), CheckboxWidget.Size.REGULAR);
        checkbox.field_22764 = visible;
        checkbox.method_47400(this.getPermissionTooltip(menuPermission));
        return checkbox;
    }

    private void updatePermission(SecurityCardData.Permission menuPermission, class_4185 resetButton, CheckboxWidget checkbox, boolean allowed) {
        this.updateCheckboxAndResetButton(checkbox, resetButton, ((AbstractSecurityCardContainerMenu)this.field_2797).changePermission(menuPermission.permission(), allowed));
    }

    private class_7919 getPermissionTooltip(SecurityCardData.Permission menuPermission) {
        PlatformPermission permission = menuPermission.permission();
        class_5250 ownerName = permission.getOwnerName().method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
        class_5250 tooltip = permission.getDescription().method_27661().method_27693("\n").method_10852((class_2561)ownerName);
        return class_7919.method_47407((class_2561)(menuPermission.dirty() ? tooltip.method_27693("\n").method_10852(MODIFIED_TITLE) : tooltip));
    }

    private class_4185 createPermissionResetButton(SecurityCardData.Permission menuPermission, CheckboxWidget checkbox, int y, boolean visible) {
        class_4185 resetButton = class_4185.method_46430((class_2561)RESET_TITLE, btn -> this.resetPermission(menuPermission, checkbox, btn)).method_46433(this.field_2776 + this.field_2792 - 16 - 40 - 11, y).method_46437(40, 16).method_46431();
        resetButton.field_22764 = visible;
        resetButton.field_22763 = menuPermission.dirty();
        return resetButton;
    }

    private void resetPermission(SecurityCardData.Permission menuPermission, CheckboxWidget checkbox, class_4185 resetButton) {
        this.updateCheckboxAndResetButton(checkbox, resetButton, ((AbstractSecurityCardContainerMenu)this.field_2797).resetPermission(menuPermission.permission()));
    }

    private void updateCheckboxAndResetButton(CheckboxWidget checkbox, class_4185 resetButton, SecurityCardData.Permission menuPermission) {
        checkbox.method_25355(this.getPermissionName(menuPermission));
        checkbox.method_47400(this.getPermissionTooltip(menuPermission));
        checkbox.setSelected(menuPermission.allowed());
        resetButton.field_22763 = menuPermission.dirty();
    }

    private class_2561 getPermissionName(SecurityCardData.Permission menuPermission) {
        class_2561 name = menuPermission.permission().getName();
        if (!menuPermission.dirty()) {
            return name;
        }
        return name.method_27661().method_27693(" (*)").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
    }

    private int getPermissionY(int index) {
        return this.field_2800 + 19 + index * 18 + 3;
    }

    private boolean isPermissionVisible(int rows, int y) {
        return y >= this.field_2800 + 19 - 18 && y < this.field_2800 + 19 + rows * 18;
    }

    @Override
    protected int getScrollPanePadding() {
        return 4;
    }

    @Override
    protected void scrollbarChanged(int rows) {
        int offset = this.getScrollbarOffset();
        for (int i = 0; i < this.permissions.size(); ++i) {
            Permission permission = this.permissions.get(i);
            int y = this.getPermissionY(i) - offset;
            boolean visible = this.isPermissionVisible(rows, y);
            permission.setY(y);
            permission.setVisible(visible);
        }
    }

    @Override
    protected void renderRows(class_332 graphics, int x, int y, int topHeight, int rows, int mouseX, int mouseY) {
        for (Permission permission : this.permissions) {
            permission.render(graphics, mouseX, mouseY);
        }
    }

    @Override
    protected void renderStretchingBackground(class_332 graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.method_25302(this.getTexture(), x, y + 18 * row, 0, textureY, this.field_2792, 18);
        }
    }

    @Override
    protected int getBottomHeight() {
        return 99;
    }

    @Override
    protected int getBottomV() {
        return 73;
    }

    @Override
    protected class_2960 getTexture() {
        return TEXTURE;
    }

    private record Permission(CheckboxWidget checkbox, class_4185 resetButton) {
        private void setY(int y) {
            this.checkbox.method_46419(y);
            this.resetButton.method_46419(y);
        }

        private void setVisible(boolean visible) {
            this.checkbox.field_22764 = visible;
            this.resetButton.field_22764 = visible;
        }

        private void render(class_332 graphics, int mouseX, int mouseY) {
            this.checkbox.method_25394(graphics, mouseX, mouseY, 0.0f);
            this.resetButton.method_25394(graphics, mouseX, mouseY, 0.0f);
        }
    }
}

