/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.security.PlatformPermission;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.security.AbstractSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.PlayerBoundSecurityCardData;
import com.refinedmods.refinedstorage.common.security.SecurityCardBoundPlayer;
import com.refinedmods.refinedstorage.common.security.SecurityCardExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5632;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class SecurityCardItem
extends AbstractSecurityCardItem<PlayerBoundSecurityCardData> {
    private static final class_2561 UNBOUND_HELP = IdentifierUtil.createTranslation("item", "security_card.unbound.help");
    private static final class_2561 BOUND_HELP = IdentifierUtil.createTranslation("item", "security_card.bound.help");

    public SecurityCardItem() {
        super(new class_1792.class_1793().method_7889(1));
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> lines, class_1836 flag) {
        SecurityCardBoundPlayer boundPlayer = (SecurityCardBoundPlayer)stack.method_57824(DataComponents.INSTANCE.getSecurityCardBoundPlayer());
        if (boundPlayer == null) {
            lines.add((class_2561)IdentifierUtil.createTranslation("item", "security_card.unbound").method_27692(class_124.field_1080));
        } else {
            lines.add((class_2561)IdentifierUtil.createTranslation("item", "security_card.bound", class_2561.method_43470((String)boundPlayer.playerName()).method_27692(class_124.field_1054)).method_27692(class_124.field_1080));
        }
        super.method_7851(stack, context, lines, flag);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!stack.method_57826(DataComponents.INSTANCE.getSecurityCardBoundPlayer())) {
                this.setBoundPlayer(serverPlayer, stack);
            }
        }
        return super.method_7836(level, player, hand);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new HelpTooltipComponent(this.isValid(stack) ? BOUND_HELP : UNBOUND_HELP));
    }

    @Override
    AbstractSecurityCardExtendedMenuProvider<PlayerBoundSecurityCardData> createMenuProvider(MinecraftServer server, SlotReference slotReference, SecurityPolicy policy, Set<PlatformPermission> dirtyPermissions, class_1799 stack) {
        return new SecurityCardExtendedMenuProvider((class_2561)stack.method_57824(class_9334.field_49631), server, slotReference, policy, dirtyPermissions, Objects.requireNonNull((SecurityCardBoundPlayer)stack.method_57824(DataComponents.INSTANCE.getSecurityCardBoundPlayer())));
    }

    @Override
    public boolean isValid(class_1799 stack) {
        return stack.method_57826(DataComponents.INSTANCE.getSecurityCardBoundPlayer());
    }

    @Override
    public Optional<SecurityActor> getActor(class_1799 stack) {
        return Optional.ofNullable((SecurityCardBoundPlayer)stack.method_57824(DataComponents.INSTANCE.getSecurityCardBoundPlayer())).map(SecurityCardBoundPlayer::toSecurityActor);
    }

    @Override
    public long getEnergyUsage() {
        return Platform.INSTANCE.getConfig().getSecurityCard().getEnergyUsage();
    }

    void setBoundPlayer(class_3222 player, class_1799 stack) {
        SecurityCardBoundPlayer boundPlayer = SecurityCardBoundPlayer.of(player);
        stack.method_57379(DataComponents.INSTANCE.getSecurityCardBoundPlayer(), (Object)boundPlayer);
    }
}

