/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.api.network.impl.node.security.SecurityDecisionProviderProxyNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.security.SecurityDecisionProviderImpl;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityPolicy;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.security.SecurityHelper;
import com.refinedmods.refinedstorage.common.api.security.SecurityPolicyContainerItem;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.security.BuiltinPermission;
import com.refinedmods.refinedstorage.common.security.FallbackSecurityCardItem;
import com.refinedmods.refinedstorage.common.security.SecurityManagerConnectionStrategy;
import com.refinedmods.refinedstorage.common.security.SecurityManagerContainerMenu;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeContainerProviderImpl;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class SecurityManagerBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SecurityDecisionProviderProxyNetworkNode>
implements BlockEntityWithDrops,
NetworkNodeMenuProvider {
    static final int CARD_AMOUNT = 18;
    private static final String TAG_SECURITY_CARDS = "sc";
    private static final String TAG_FALLBACK_SECURITY_CARD = "fsc";
    private final FilteredContainer securityCards = new FilteredContainer(18, SecurityManagerBlockEntity::isValidSecurityCard);
    private final FilteredContainer fallbackSecurityCard = new FilteredContainer(1, SecurityManagerBlockEntity::isValidFallbackSecurityCard);
    private final SecurityDecisionProviderImpl securityDecisionProvider = new SecurityDecisionProviderImpl();

    public SecurityManagerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getSecurityManager(), pos, state, new SecurityDecisionProviderProxyNetworkNode(Platform.INSTANCE.getConfig().getSecurityManager().getEnergyUsage()));
        this.securityCards.method_5489(card -> this.invalidate());
        this.fallbackSecurityCard.method_5489(card -> this.invalidate());
        ((SecurityDecisionProviderProxyNetworkNode)this.mainNetworkNode).setDelegate(this.securityDecisionProvider);
    }

    @Override
    protected NetworkNodeContainerProvider createContainerProvider() {
        return new NetworkNodeContainerProviderImpl(){

            @Override
            public boolean canBuild(class_3222 player) {
                return super.canBuild(player) || SecurityManagerBlockEntity.this.isPlacedBy(player.method_7334().getId());
            }
        };
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(SecurityDecisionProviderProxyNetworkNode networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, networkNode).connectionStrategy(new SecurityManagerConnectionStrategy(() -> ((SecurityManagerBlockEntity)this).method_11010(), this.method_11016())).build();
    }

    private void invalidate() {
        if (this.field_11863 != null) {
            this.method_5431();
        }
        this.securityDecisionProvider.clearPolicies();
        long energyUsage = Platform.INSTANCE.getConfig().getSecurityManager().getEnergyUsage();
        for (int i = 0; i < this.securityCards.method_5439(); ++i) {
            class_1799 securityCard = this.securityCards.method_5438(i);
            class_1792 class_17922 = securityCard.method_7909();
            if (!(class_17922 instanceof SecurityPolicyContainerItem)) continue;
            SecurityPolicyContainerItem securityPolicyContainerItem = (SecurityPolicyContainerItem)class_17922;
            energyUsage += securityPolicyContainerItem.getEnergyUsage();
            securityPolicyContainerItem.getPolicy(securityCard).ifPresent(policy -> securityPolicyContainerItem.getActor(securityCard).ifPresent(actor -> this.securityDecisionProvider.setPolicy((SecurityActor)actor, (SecurityPolicy)policy)));
        }
        ((SecurityDecisionProviderProxyNetworkNode)this.mainNetworkNode).setEnergyUsage(energyUsage += this.updateDefaultPolicyAndGetEnergyUsage());
    }

    private long updateDefaultPolicyAndGetEnergyUsage() {
        class_1799 fallbackSecurityCardStack = this.fallbackSecurityCard.method_5438(0);
        class_1792 class_17922 = fallbackSecurityCardStack.method_7909();
        if (class_17922 instanceof SecurityPolicyContainerItem) {
            SecurityPolicyContainerItem securityPolicyContainerItem = (SecurityPolicyContainerItem)class_17922;
            securityPolicyContainerItem.getPolicy(fallbackSecurityCardStack).ifPresentOrElse(this.securityDecisionProvider::setDefaultPolicy, () -> this.securityDecisionProvider.setDefaultPolicy(null));
            return securityPolicyContainerItem.getEnergyUsage();
        }
        this.securityDecisionProvider.setDefaultPolicy(null);
        return 0L;
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_SECURITY_CARDS)) {
            ContainerUtil.read(tag.method_10562(TAG_SECURITY_CARDS), (class_1263)this.securityCards, provider);
        }
        if (tag.method_10545(TAG_FALLBACK_SECURITY_CARD)) {
            ContainerUtil.read(tag.method_10562(TAG_FALLBACK_SECURITY_CARD), (class_1263)this.fallbackSecurityCard, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_SECURITY_CARDS, (class_2520)ContainerUtil.write((class_1263)this.securityCards, provider));
        tag.method_10566(TAG_FALLBACK_SECURITY_CARD, (class_2520)ContainerUtil.write((class_1263)this.fallbackSecurityCard, provider));
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.securityCards.method_5439(); ++i) {
            drops.add((Object)this.securityCards.method_5438(i));
        }
        drops.add((Object)this.fallbackSecurityCard.method_5438(0));
        return drops;
    }

    FilteredContainer getSecurityCards() {
        return this.securityCards;
    }

    FilteredContainer getFallbackSecurityCard() {
        return this.fallbackSecurityCard;
    }

    static boolean isValidSecurityCard(class_1799 stack) {
        SecurityPolicyContainerItem securityPolicyContainerItem;
        class_1792 class_17922 = stack.method_7909();
        return class_17922 instanceof SecurityPolicyContainerItem && (securityPolicyContainerItem = (SecurityPolicyContainerItem)class_17922).isValid(stack) && !(stack.method_7909() instanceof FallbackSecurityCardItem);
    }

    static boolean isValidFallbackSecurityCard(class_1799 stack) {
        return stack.method_7909() instanceof FallbackSecurityCardItem;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.SECURITY_MANAGER);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new SecurityManagerContainerMenu(syncId, inventory, this);
    }

    @Override
    public boolean canOpen(class_3222 player) {
        boolean isAllowedViaSecuritySystem = NetworkNodeMenuProvider.super.canOpen(player) && SecurityHelper.isAllowed(player, (Permission)BuiltinPermission.SECURITY, this.containers.getContainers());
        return isAllowedViaSecuritySystem || this.isPlacedBy(player.method_7334().getId());
    }
}

