/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.security;

import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.security.SecurityManagerBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2586;

public class SecurityManagerContainerMenu
extends AbstractBaseContainerMenu {
    private final Predicate<class_1657> stillValid;
    @Nullable
    private class_1735 fallbackSecurityCardSlot;

    public SecurityManagerContainerMenu(int syncId, class_1661 playerInventory) {
        super(Menus.INSTANCE.getSecurityManager(), syncId);
        this.addSlots(playerInventory, new FilteredContainer(18, SecurityManagerBlockEntity::isValidSecurityCard), new FilteredContainer(1, SecurityManagerBlockEntity::isValidFallbackSecurityCard));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.stillValid = player -> true;
    }

    SecurityManagerContainerMenu(int syncId, class_1661 playerInventory, SecurityManagerBlockEntity securityManager) {
        super(Menus.INSTANCE.getSecurityManager(), syncId);
        this.addSlots(playerInventory, securityManager.getSecurityCards(), securityManager.getFallbackSecurityCard());
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, securityManager::getRedstoneMode, securityManager::setRedstoneMode));
        this.stillValid = player -> class_1263.method_49105((class_2586)securityManager, (class_1657)player);
    }

    private void addSlots(class_1661 playerInventory, FilteredContainer securityCards, FilteredContainer fallbackSecurityCard) {
        for (int i = 0; i < 18; ++i) {
            int column = i % 9;
            int x = 8 + column * 18;
            int row = i / 9;
            int y = 20 + row * 18;
            this.method_7621(new ValidatedSlot((class_1263)securityCards, i, x, y, SecurityManagerBlockEntity::isValidSecurityCard));
        }
        this.fallbackSecurityCardSlot = new ValidatedSlot((class_1263)fallbackSecurityCard, 0, 174, 20, SecurityManagerBlockEntity::isValidFallbackSecurityCard);
        this.method_7621(this.fallbackSecurityCardSlot);
        this.addPlayerInventory(playerInventory, 8, 72);
        this.transferManager.addBiTransfer((class_1263)playerInventory, (class_1263)securityCards);
        this.transferManager.addBiTransfer((class_1263)playerInventory, (class_1263)fallbackSecurityCard);
    }

    @Nullable
    class_1735 getFallbackSecurityCardSlot() {
        return this.fallbackSecurityCardSlot;
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }
}

