/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public class BucketPlayerInventoryInsertableStorage
implements InsertableStorage {
    private static final class_1799 EMPTY_BUCKET_STACK = new class_1799((class_1935)class_1802.field_8550);
    private static final ItemResource EMPTY_BUCKET_RESOURCE = ItemResource.ofItemStack(EMPTY_BUCKET_STACK);
    private final class_1661 playerInventory;
    private final Storage emptyBucketStorage;
    private final boolean mayDropFilledBucket;

    public BucketPlayerInventoryInsertableStorage(class_1661 playerInventory, Storage emptyBucketStorage, boolean mayDropFilledBucket) {
        this.playerInventory = playerInventory;
        this.emptyBucketStorage = emptyBucketStorage;
        this.mayDropFilledBucket = mayDropFilledBucket;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        if (!(resource instanceof FluidResource)) {
            return 0L;
        }
        FluidResource fluidResource = (FluidResource)resource;
        if (amount != Platform.INSTANCE.getBucketAmount()) {
            return 0L;
        }
        ResourceAmount toFill = new ResourceAmount(fluidResource, amount);
        return Platform.INSTANCE.fillContainer(EMPTY_BUCKET_STACK, toFill).map(result -> this.insert(result.container(), amount, action, actor)).orElse(0L);
    }

    private long insert(class_1799 filledBucketStack, long amount, Action action, Actor actor) {
        if (this.extractBucketFromInventory(action)) {
            return this.insert(filledBucketStack, amount, action, this::returnBucketToInventory);
        }
        if (this.extractBucketFromStorage(action, actor)) {
            return this.insert(filledBucketStack, amount, action, () -> this.returnBucketToStorage(actor));
        }
        return 0L;
    }

    private long insert(class_1799 filledBucketStack, long amount, Action action, Runnable rollbackAction) {
        if (action == Action.EXECUTE && !this.playerInventory.method_7394(filledBucketStack)) {
            if (this.mayDropFilledBucket) {
                this.playerInventory.field_7546.method_7328(filledBucketStack, false);
            } else {
                rollbackAction.run();
                return 0L;
            }
        }
        return amount;
    }

    private boolean extractBucketFromInventory(Action action) {
        for (int i = 0; i < this.playerInventory.method_5439(); ++i) {
            class_1799 stack = this.playerInventory.method_5438(i);
            if (stack.method_7909() != class_1802.field_8550) continue;
            if (action == Action.EXECUTE) {
                this.playerInventory.method_5434(i, 1);
            }
            return true;
        }
        return false;
    }

    private void returnBucketToInventory() {
        this.playerInventory.method_7394(EMPTY_BUCKET_STACK);
    }

    private boolean extractBucketFromStorage(Action action, Actor actor) {
        return this.emptyBucketStorage.extract(EMPTY_BUCKET_RESOURCE, 1L, action, actor) == 1L;
    }

    private void returnBucketToStorage(Actor actor) {
        this.emptyBucketStorage.insert(EMPTY_BUCKET_RESOURCE, 1L, Action.EXECUTE, actor);
    }
}

