/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_7923;

public class DiskInventory
extends FilteredContainer
implements AbstractStorageContainerNetworkNode.Provider {
    private static final String TAG_DISK_STATE = "s";
    private static final String TAG_DISK_ITEM_ID = "i";
    private final DiskListener listener;
    @Nullable
    private StorageRepository storageRepository;

    public DiskInventory(DiskListener listener, int diskCount) {
        super(diskCount, StorageContainerItem.stackValidator());
        this.listener = listener;
    }

    public void setStorageRepository(@Nullable StorageRepository storageRepository) {
        this.storageRepository = storageRepository;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = super.method_5434(slot, amount);
        this.listener.onDiskChanged(this, slot);
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.listener.onDiskChanged(this, slot);
    }

    @Override
    public Optional<Storage> resolve(int index) {
        if (this.storageRepository == null) {
            return Optional.empty();
        }
        return this.validateAndGetStack(index).flatMap(stack -> ((StorageContainerItem)stack.method_7909()).resolve(this.storageRepository, (class_1799)stack));
    }

    private Optional<class_1799> validateAndGetStack(int slot) {
        class_1799 stack = this.method_5438(slot);
        if (stack.method_7960() || !(stack.method_7909() instanceof StorageContainerItem)) {
            return Optional.empty();
        }
        return Optional.of(stack);
    }

    public class_2499 toSyncTag(IntFunction<StorageState> stateProvider) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_2487 disk = new class_2487();
            disk.method_10567(TAG_DISK_STATE, (byte)stateProvider.apply(i).ordinal());
            class_1799 diskItem = this.method_5438(i);
            if (!diskItem.method_7960()) {
                disk.method_10569(TAG_DISK_ITEM_ID, class_7923.field_41178.method_10206((Object)diskItem.method_7909()));
            }
            list.add((Object)disk);
        }
        return list;
    }

    public Disk[] fromSyncTag(class_2499 list) {
        Disk[] disks = new Disk[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            class_2487 diskTag = list.method_10602(i);
            disks[i] = class_7923.field_41178.method_40265(diskTag.method_10550(TAG_DISK_ITEM_ID)).map(item -> new Disk((class_1792)item.comp_349(), this.getState(diskTag))).orElse(new Disk(null, StorageState.NONE));
        }
        return disks;
    }

    private StorageState getState(class_2487 tag) {
        byte stateOrdinal = tag.method_10571(TAG_DISK_STATE);
        StorageState[] values = StorageState.values();
        if (stateOrdinal < 0 || stateOrdinal >= values.length) {
            return StorageState.NONE;
        }
        return values[stateOrdinal];
    }

    @FunctionalInterface
    public static interface DiskListener {
        public void onDiskChanged(DiskInventory var1, int var2);
    }
}

