/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import net.minecraft.class_2586;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStateChangeListener
implements StateTrackedStorage.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskStateChangeListener.class);
    private final class_2586 blockEntity;
    private final RateLimiter rateLimiter = RateLimiter.create((double)1.0);
    private boolean syncRequested;

    public DiskStateChangeListener(class_2586 blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public void onStorageStateChanged() {
        this.syncRequested = true;
    }

    public void updateIfNecessary() {
        if (!this.syncRequested) {
            return;
        }
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        LOGGER.debug("Disk state change for block at {}", (Object)this.blockEntity.method_11016());
        this.syncRequested = false;
        PlatformUtil.sendBlockUpdateToClient(this.blockEntity.method_10997(), this.blockEntity.method_11016());
    }
}

