/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.BaseMapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

record ErrorHandlingMapCodec<K, V>(Codec<K> keyCodec, Codec<V> elementCodec) implements BaseMapCodec<K, V>,
Codec<Map<K, V>>
{
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlingMapCodec.class);
    private static final String ERROR_MESSAGE = "Refined Storage could not load a storage. Error message:";

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.safeDecode(ops, (MapLike)map)).map(r -> Pair.of((Object)r, (Object)input));
    }

    private <T> DataResult<Map<K, V>> safeDecode(DynamicOps<T> ops, MapLike<T> input) {
        Object2ObjectArrayMap read = new Object2ObjectArrayMap();
        input.entries().forEach(arg_0 -> this.lambda$safeDecode$4(ops, (Object2ObjectMap)read, arg_0));
        ImmutableMap elements = ImmutableMap.copyOf((Map)read);
        return DataResult.success((Object)elements);
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    @Override
    public String toString() {
        return "ErrorHandlingMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
    }

    private /* synthetic */ void lambda$safeDecode$4(DynamicOps ops, Object2ObjectMap read, Pair entry) {
        DataResult key = this.keyCodec().parse(ops, entry.getFirst());
        DataResult value = this.elementCodec().parse(ops, entry.getSecond());
        DataResult entryResult = key.apply2stable(Pair::of, value);
        entryResult.resultOrPartial().ifPresent(pair -> read.putIfAbsent(pair.getFirst(), pair.getSecond()));
        entryResult.error().ifPresent(e -> LOGGER.warn("{} {}", (Object)ERROR_MESSAGE, (Object)e.message()));
    }
}

