/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.StorageImpl;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorageImpl;
import com.refinedmods.refinedstorage.api.storage.tracked.InMemoryTrackedStorageRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedStorageImpl;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageType;
import com.refinedmods.refinedstorage.common.storage.LimitedPlatformStorage;
import com.refinedmods.refinedstorage.common.storage.PlatformStorage;
import com.refinedmods.refinedstorage.common.storage.StorageCodecs;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class SameTypeStorageType<T extends ResourceKey>
implements StorageType {
    private final Codec<T> codec;
    private final Predicate<ResourceKey> valid;
    private final Function<ResourceKey, T> caster;
    private final long diskInterfaceTransferQuota;
    private final long diskInterfaceTransferQuotaWithStackUpgrade;

    public SameTypeStorageType(Codec<T> codec, Predicate<ResourceKey> valid, Function<ResourceKey, T> caster, long diskInterfaceTransferQuota, long diskInterfaceTransferQuotaWithStackUpgrade) {
        this.codec = codec;
        this.valid = valid;
        this.caster = caster;
        this.diskInterfaceTransferQuota = diskInterfaceTransferQuota;
        this.diskInterfaceTransferQuotaWithStackUpgrade = diskInterfaceTransferQuotaWithStackUpgrade;
    }

    @Override
    public SerializableStorage create(@Nullable Long capacity, Runnable listener) {
        return this.createStorage(StorageCodecs.StorageData.empty(capacity), listener);
    }

    @Override
    public MapCodec<SerializableStorage> getMapCodec(Runnable listener) {
        return StorageCodecs.sameTypeStorageData(this.codec).xmap(storageData -> this.createStorage((StorageCodecs.StorageData<T>)storageData, listener), storage -> StorageCodecs.StorageData.ofSameTypeStorage(storage, this.valid, this.caster));
    }

    @Override
    public boolean isAllowed(ResourceKey resource) {
        return this.valid.test(resource);
    }

    @Override
    public long getDiskInterfaceTransferQuota(boolean stackUpgrade) {
        if (stackUpgrade) {
            return this.diskInterfaceTransferQuotaWithStackUpgrade;
        }
        return this.diskInterfaceTransferQuota;
    }

    private SerializableStorage createStorage(StorageCodecs.StorageData<T> data, Runnable listener) {
        InMemoryTrackedStorageRepository trackingRepository = new InMemoryTrackedStorageRepository();
        TrackedStorageImpl tracked = new TrackedStorageImpl(new StorageImpl(), trackingRepository, System::currentTimeMillis);
        PlatformStorage storage = data.capacity().map(capacity -> {
            LimitedStorageImpl limited = new LimitedStorageImpl(tracked, (long)capacity);
            return new LimitedPlatformStorage(limited, (StorageType)this, trackingRepository, listener);
        }).orElseGet(() -> new PlatformStorage(tracked, this, trackingRepository, listener));
        data.resources().forEach(storage::load);
        return storage;
    }
}

