/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.storage.StorageTooltipHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContainerItemHelperImpl
implements StorageContainerItemHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageContainerItemHelperImpl.class);

    @Override
    public Optional<SerializableStorage> resolveStorage(StorageRepository storageRepository, class_1799 stack) {
        return this.getId(stack).flatMap(storageRepository::get);
    }

    @Override
    public void loadStorageIfNecessary(class_1799 stack, class_1937 level, class_1297 entity, Function<StorageRepository, SerializableStorage> factory) {
        if (!level.method_8608() && !this.hasStorage(stack) && entity instanceof class_1657) {
            StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
            this.setStorage(storageRepository, stack, factory.apply(storageRepository));
        }
    }

    @Override
    public void transferStorageIfNecessary(class_1799 stack, class_1937 level, class_1297 entity, Function<StorageRepository, SerializableStorage> factory) {
        if (!level.method_8608() && !this.hasStorage(stack) && this.hasStorageToBeTransferred(stack) && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.getIdToBeTransferred(stack).ifPresent(id -> this.doTransfer(level, factory, player, (UUID)id, stack));
        }
    }

    private void doTransfer(class_1937 level, Function<StorageRepository, SerializableStorage> factory, class_1657 player, UUID originalId, class_1799 stack) {
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        PlayerActor actor = new PlayerActor(player);
        storageRepository.get(originalId).ifPresent(originalStorage -> {
            SerializableStorage transferStorage = (SerializableStorage)factory.apply(storageRepository);
            originalStorage.getAll().forEach(original -> transferStorage.insert(original.resource(), original.amount(), Action.EXECUTE, actor));
            this.setStorage(storageRepository, stack, transferStorage);
            storageRepository.remove(originalId);
            this.markAsTransferred(stack);
        });
    }

    private void setStorage(StorageRepository storageRepository, class_1799 stack, SerializableStorage storage) {
        UUID id = UUID.randomUUID();
        this.setId(stack, id);
        storageRepository.set(id, storage);
    }

    private boolean hasStorage(class_1799 stack) {
        return stack.method_57826(DataComponents.INSTANCE.getStorageReference());
    }

    private boolean hasStorageToBeTransferred(class_1799 stack) {
        return stack.method_57826(DataComponents.INSTANCE.getStorageReferenceToBeTransferred());
    }

    @Override
    public Optional<StorageInfo> getInfo(StorageRepository storageRepository, class_1799 stack) {
        return this.getId(stack).map(storageRepository::getInfo);
    }

    @Override
    public class_1271<class_1799> tryDisassembly(class_1937 level, class_1657 player, class_1799 stack, class_1799 primaryByproduct, @Nullable class_1799 secondaryByproduct) {
        if (!(level instanceof class_3218) || !player.method_5715()) {
            return class_1271.method_22431((Object)stack);
        }
        Optional<UUID> storageId = this.getId(stack);
        if (storageId.isEmpty()) {
            return this.returnByproducts(level, player, primaryByproduct, secondaryByproduct);
        }
        return storageId.flatMap(id -> RefinedStorageApi.INSTANCE.getStorageRepository(level).removeIfEmpty((UUID)id)).map(disk -> this.returnByproducts(level, player, primaryByproduct, secondaryByproduct)).orElseGet(() -> class_1271.method_22431((Object)stack));
    }

    private class_1271<class_1799> returnByproducts(class_1937 level, class_1657 player, class_1799 primaryByproduct, @Nullable class_1799 secondaryByproduct) {
        StorageContainerItemHelperImpl.tryReturnByproductToInventory(level, player, secondaryByproduct);
        return class_1271.method_22427((Object)primaryByproduct);
    }

    private static void tryReturnByproductToInventory(class_1937 level, class_1657 player, @Nullable class_1799 byproduct) {
        if (byproduct != null && !player.method_31548().method_7394(byproduct.method_7972())) {
            level.method_8649((class_1297)new class_1542(level, player.method_23317(), player.method_23318(), player.method_23321(), byproduct));
        }
    }

    @Override
    public void appendToTooltip(class_1799 stack, StorageRepository storageRepository, List<class_2561> tooltip, class_1836 context, LongFunction<String> amountFormatter, @Nullable Long capacity) {
        boolean transferring = this.hasStorageToBeTransferred(stack);
        this.getId(stack).or(() -> this.getIdToBeTransferred(stack)).ifPresent(id -> {
            StorageInfo info = storageRepository.getInfo((UUID)id);
            if (capacity != null) {
                StorageTooltipHelper.addAmountStoredWithCapacity(tooltip, info.stored(), transferring ? capacity.longValue() : info.capacity(), amountFormatter);
            } else {
                StorageTooltipHelper.addAmountStoredWithoutCapacity(tooltip, info.stored(), amountFormatter);
            }
            if (context.method_8035()) {
                class_5250 idComponent = class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1080);
                tooltip.add((class_2561)idComponent);
            }
        });
    }

    @Override
    public void transferToBlockEntity(class_1799 stack, StorageBlockEntity blockEntity) {
        this.getId(stack).ifPresent(id -> {
            blockEntity.setStorageId((UUID)id);
            LOGGER.debug("Transferred storage {} to block entity {}", id, (Object)blockEntity);
        });
    }

    @Override
    public void transferFromBlockEntity(class_1799 stack, StorageBlockEntity blockEntity) {
        UUID storageId = blockEntity.getStorageId();
        if (storageId != null) {
            LOGGER.debug("Transferred storage {} from block entity {} to stack", (Object)storageId, (Object)blockEntity);
            this.setId(stack, storageId);
        } else {
            LOGGER.warn("Could not transfer storage {} to stack, there is no storage ID!", (Object)blockEntity);
        }
    }

    @Override
    public void markAsToTransfer(class_1799 from, class_1799 to) {
        this.getId(from).ifPresent(id -> to.method_57379(DataComponents.INSTANCE.getStorageReferenceToBeTransferred(), id));
    }

    private Optional<UUID> getId(class_1799 stack) {
        return Optional.ofNullable((UUID)stack.method_57824(DataComponents.INSTANCE.getStorageReference()));
    }

    private Optional<UUID> getIdToBeTransferred(class_1799 stack) {
        return Optional.ofNullable((UUID)stack.method_57824(DataComponents.INSTANCE.getStorageReferenceToBeTransferred()));
    }

    private void markAsTransferred(class_1799 stack) {
        stack.method_57381(DataComponents.INSTANCE.getStorageReferenceToBeTransferred());
    }

    private void setId(class_1799 stack, UUID id) {
        stack.method_57379(DataComponents.INSTANCE.getStorageReference(), (Object)id);
    }
}

