/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;

public class StorageContainerUpgradeRecipe<T extends StorageVariant>
extends class_1867 {
    private final Set<class_1792> validSourceContainers;
    private final T[] variants;
    private final T to;

    public StorageContainerUpgradeRecipe(T[] variants, T to, Function<T, class_1935> containerProvider) {
        super("", class_7710.field_40251, containerProvider.apply(to).method_8389().method_7854(), StorageContainerUpgradeRecipe.getIngredients(variants, to, containerProvider));
        this.validSourceContainers = StorageContainerUpgradeRecipe.getValidSourceContainers(to, variants, containerProvider);
        this.variants = variants;
        this.to = to;
    }

    private static <T extends StorageVariant> class_2371<class_1856> getIngredients(T[] variants, T to, Function<T, class_1935> containerProvider) {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.add((Object)class_1856.method_8091((class_1935[])((class_1935[])StorageContainerUpgradeRecipe.getValidSourceContainers(to, variants, containerProvider).toArray(new class_1792[0]))));
        ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{to.getStoragePart()}));
        return ingredients;
    }

    public T[] getVariants() {
        return this.variants;
    }

    public T getTo() {
        return this.to;
    }

    private static <T extends StorageVariant> Set<class_1792> getValidSourceContainers(T destination, T[] variants, Function<T, class_1935> containerProvider) {
        if (destination.getCapacity() == null) {
            return Set.of();
        }
        return Arrays.stream(variants).filter(variant -> variant.getCapacity() != null && variant.getCapacity() < destination.getCapacity()).map(containerProvider).map(class_1935::method_8389).collect(Collectors.toSet());
    }

    public class_1799 method_17729(class_9694 input, class_7225.class_7874 provider) {
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 fromDisk = input.method_59984(i);
            class_1792 class_17922 = fromDisk.method_7909();
            if (!(class_17922 instanceof UpgradeableStorageContainer)) continue;
            UpgradeableStorageContainer from = (UpgradeableStorageContainer)class_17922;
            if (!this.validSourceContainers.contains(fromDisk.method_7909())) continue;
            class_1799 toDisk = this.method_8110(provider).method_7972();
            from.transferTo(fromDisk, toDisk);
            return toDisk;
        }
        return class_1799.field_8037;
    }

    public boolean method_17730(class_9694 input, class_1937 level) {
        int diskCount = 0;
        int partCount = 0;
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 inputStack = input.method_59984(i);
            if (this.validSourceContainers.contains(inputStack.method_7909())) {
                ++diskCount;
            } else if (inputStack.method_7909() == this.to.getStoragePart()) {
                ++partCount;
            }
            if (diskCount != 1 || partCount != 1) continue;
            return true;
        }
        return false;
    }

    public class_2371<class_1799> getRemainingItems(class_9694 input) {
        class_2371 remainingItems = class_2371.method_10213((int)input.method_59983(), (Object)class_1799.field_8037);
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1792 storagePart;
            class_1799 stack = input.method_59984(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof UpgradeableStorageContainer)) continue;
            UpgradeableStorageContainer from = (UpgradeableStorageContainer)class_17922;
            if (!this.validSourceContainers.contains(stack.method_7909()) || (storagePart = from.getVariant().getStoragePart()) == null) continue;
            remainingItems.set(i, (Object)storagePart.method_7854());
        }
        return remainingItems;
    }
}

