/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.storage.ErrorHandlingMapCodec;
import com.refinedmods.refinedstorage.common.support.AbstractPlatformSavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_4844;
import net.minecraft.class_7225;

public class StorageRepositoryImpl
extends AbstractPlatformSavedData
implements StorageRepository {
    public static final String NAME = "refinedstorage_storages";
    private final Codec<Map<UUID, SerializableStorage>> codec = StorageRepositoryImpl.createCodec(this::markAsChanged);
    private final Map<UUID, SerializableStorage> entries;

    public StorageRepositoryImpl(class_2487 tag, class_7225.class_7874 provider) {
        this.entries = new HashMap<UUID, SerializableStorage>((Map)((Pair)this.codec.decode((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).getOrThrow()).getFirst());
    }

    public StorageRepositoryImpl() {
        this.entries = new HashMap<UUID, SerializableStorage>();
    }

    private static Codec<Map<UUID, SerializableStorage>> createCodec(Runnable listener) {
        Codec storageCodec = RefinedStorageApi.INSTANCE.getStorageTypeRegistry().codec().dispatch(SerializableStorage::getType, storage -> storage.getMapCodec(listener));
        return new ErrorHandlingMapCodec<UUID, SerializableStorage>(class_4844.field_41525, storageCodec);
    }

    @Override
    public Optional<SerializableStorage> get(UUID id) {
        return Optional.ofNullable(this.entries.get(id));
    }

    @Override
    public void set(UUID id, SerializableStorage storage) {
        CoreValidations.validateNotNull(storage, "Storage must not be null");
        CoreValidations.validateNotNull(id, "ID must not be null");
        if (this.entries.containsKey(id)) {
            throw new IllegalArgumentException(String.valueOf(id) + " already exists");
        }
        this.entries.put(id, storage);
        this.method_80();
    }

    @Override
    public Optional<SerializableStorage> removeIfEmpty(UUID id) {
        return this.get(id).map(storage -> {
            if (storage.getStored() == 0L) {
                this.remove(id);
                return storage;
            }
            return null;
        });
    }

    @Override
    public void remove(UUID id) {
        this.entries.remove(id);
        this.method_80();
    }

    @Override
    public StorageInfo getInfo(UUID id) {
        return this.get(id).map(StorageInfo::of).orElse(StorageInfo.UNKNOWN);
    }

    @Override
    public void markAsChanged() {
        this.method_80();
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 provider) {
        return (class_2487)this.codec.encode(this.entries, (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).getOrThrow();
    }
}

