/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskdrive;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageInfo;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.storage.diskdrive.StorageDiskInfoAccessor;
import com.refinedmods.refinedstorage.common.storage.diskdrive.StorageDiskInfoAccessorImpl;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class DiskDriveContainerMenu
extends AbstractStorageContainerMenu
implements StorageAccessor {
    private static final int DISK_SLOT_X = 61;
    private static final int DISK_SLOT_Y = 54;
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final StorageDiskInfoAccessor storageInfoAccessor;
    private final List<class_1735> diskSlots = new ArrayList<class_1735>();
    private final Predicate<class_1657> stillValid;

    public DiskDriveContainerMenu(int syncId, class_1661 playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getDiskDrive(), syncId);
        this.storageInfoAccessor = new StorageDiskInfoAccessorImpl(RefinedStorageApi.INSTANCE.getClientStorageRepository());
        this.addSlots(playerInventory.field_7546, new FilteredContainer(8, StorageContainerItem.stackValidator()), ResourceContainerImpl.createForFilter(resourceContainerData));
        this.stillValid = p -> true;
    }

    DiskDriveContainerMenu(int syncId, class_1657 player, FilteredContainer diskInventory, ResourceContainer filterContainer, StorageConfigurationContainer configContainer, StorageDiskInfoAccessor storageInfoAccessor, Predicate<class_1657> stillValid) {
        super(Menus.INSTANCE.getDiskDrive(), syncId, player, configContainer);
        this.storageInfoAccessor = storageInfoAccessor;
        this.addSlots(player, diskInventory, filterContainer);
        this.stillValid = stillValid;
    }

    private void addSlots(class_1657 player, FilteredContainer diskInventory, ResourceContainer filterContainer) {
        int i;
        for (i = 0; i < diskInventory.method_5439(); ++i) {
            this.diskSlots.add(this.method_7621(this.createDiskSlot(diskInventory, i)));
        }
        for (i = 0; i < filterContainer.size(); ++i) {
            this.method_7621(this.createFilterSlot(filterContainer, i));
        }
        this.addPlayerInventory(player.method_31548(), 8, 141);
        this.transferManager.addBiTransfer((class_1263)player.method_31548(), (class_1263)diskInventory);
        this.transferManager.addFilterTransfer((class_1263)player.method_31548());
    }

    private class_1735 createFilterSlot(ResourceContainer filterContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(filterContainer, i, (class_2561)IdentifierUtil.createTranslation("gui", "storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    private class_1735 createDiskSlot(FilteredContainer diskInventory, int i) {
        int x = 61 + i % 2 * 18;
        int y = 54 + Math.floorDiv(i, 2) * 18;
        return ValidatedSlot.forStorageContainer((class_1263)diskInventory, i, x, y);
    }

    @Override
    public boolean hasCapacity() {
        return this.getStorageDiskInfo().allMatch(info -> info.capacity() > 0L);
    }

    @Override
    public double getProgress() {
        if (!this.hasCapacity()) {
            return 0.0;
        }
        return (double)this.getStored() / (double)this.getCapacity();
    }

    @Override
    public long getCapacity() {
        return this.getStorageDiskInfo().mapToLong(StorageInfo::capacity).sum();
    }

    @Override
    public long getStored() {
        return this.getStorageDiskInfo().mapToLong(StorageInfo::stored).sum();
    }

    private Stream<class_1799> getDiskStacks() {
        return this.diskSlots.stream().map(class_1735::method_7677).filter(stack -> !stack.method_7960());
    }

    private Stream<StorageInfo> getStorageDiskInfo() {
        return this.getDiskStacks().map(this.storageInfoAccessor::getInfo).flatMap(Optional::stream);
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }
}

