/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.AbstractDiskContainerBlockEntity;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceContainerMenu;
import com.refinedmods.refinedstorage.common.storage.diskinterface.TransferModeSettings;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class AbstractDiskInterfaceBlockEntity
extends AbstractDiskContainerBlockEntity<StorageTransferNetworkNode>
implements StorageTransferListener {
    public static final int AMOUNT_OF_DISKS = 6;
    private static final String TAG_UPGRADES = "upgr";
    private static final String TAG_FILTER_MODE = "fim";
    private static final String TAG_TRANSFER_MODE = "tm";
    private final UpgradeContainer upgradeContainer = new UpgradeContainer((UpgradeDestination)UpgradeDestinations.DISK_INTERFACE, (c, upgradeEnergyUsage) -> {
        long baseEnergyUsage = Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsage();
        ((StorageTransferNetworkNode)this.mainNetworkNode).setEnergyUsage(baseEnergyUsage + upgradeEnergyUsage);
        this.method_5431();
    });

    protected AbstractDiskInterfaceBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getDiskInterface(), pos, state, new StorageTransferNetworkNode(Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsage(), Platform.INSTANCE.getConfig().getDiskInterface().getEnergyUsagePerDisk(), 6));
        this.ticker = this.upgradeContainer.getTicker();
        ((StorageTransferNetworkNode)this.mainNetworkNode).setListener(this);
        ((StorageTransferNetworkNode)this.mainNetworkNode).setTransferQuotaProvider(storage -> {
            if (storage instanceof SerializableStorage) {
                SerializableStorage serializableStorage = (SerializableStorage)storage;
                return serializableStorage.getType().getDiskInterfaceTransferQuota(this.upgradeContainer.has(Items.INSTANCE.getStackUpgrade()));
            }
            return 1L;
        });
    }

    @Override
    protected void setFilters(Set<ResourceKey> filters) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setFilters(filters);
    }

    @Override
    protected void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setNormalizer(normalizer);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_UPGRADES)) {
            ContainerUtil.read(tag.method_10562(TAG_UPGRADES), (class_1263)this.upgradeContainer, provider);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_UPGRADES, (class_2520)ContainerUtil.write((class_1263)this.upgradeContainer, provider));
        tag.method_10569(TAG_FILTER_MODE, FilterModeSettings.getFilterMode(((StorageTransferNetworkNode)this.mainNetworkNode).getFilterMode()));
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        if (tag.method_10545(TAG_TRANSFER_MODE)) {
            ((StorageTransferNetworkNode)this.mainNetworkNode).setMode(TransferModeSettings.getTransferMode(tag.method_10550(TAG_TRANSFER_MODE)));
        }
        if (tag.method_10545(TAG_FILTER_MODE)) {
            ((StorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode(tag.method_10550(TAG_FILTER_MODE)));
        }
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        tag.method_10569(TAG_TRANSFER_MODE, TransferModeSettings.getTransferMode(((StorageTransferNetworkNode)this.mainNetworkNode).getMode()));
    }

    @Override
    public List<class_1799> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    @Override
    public boolean addUpgrade(class_1799 upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.DISK_INTERFACE);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new DiskInterfaceContainerMenu(syncId, player, this, this.diskInventory, this.filter.getFilterContainer(), this.upgradeContainer);
    }

    @Override
    public final class_2371<class_1799> getDrops() {
        class_2371<class_1799> drops = super.getDrops();
        for (int i = 0; i < this.upgradeContainer.method_5439(); ++i) {
            drops.add((Object)this.upgradeContainer.method_5438(i));
        }
        return drops;
    }

    boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
        this.method_5431();
    }

    FilterMode getFilterMode() {
        return ((StorageTransferNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    void setFilterMode(FilterMode mode) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.method_5431();
    }

    public StorageTransferMode getTransferMode() {
        return ((StorageTransferNetworkNode)this.mainNetworkNode).getMode();
    }

    public void setTransferMode(StorageTransferMode mode) {
        ((StorageTransferNetworkNode)this.mainNetworkNode).setMode(mode);
        this.method_5431();
    }

    @Override
    public void onTransferSuccess(int index) {
        class_1799 diskStack = this.diskInventory.method_5438(index);
        if (diskStack.method_7960()) {
            return;
        }
        for (int newIndex = 3; newIndex < 6; ++newIndex) {
            if (!this.diskInventory.method_5438(newIndex).method_7960()) continue;
            this.diskInventory.method_5447(index, class_1799.field_8037);
            this.diskInventory.method_5447(newIndex, diskStack);
            return;
        }
    }
}

