/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.diskinterface;

import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.diskinterface.AbstractDiskInterfaceBlockEntity;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfacePropertyTypes;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.ValidatedSlot;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public class DiskInterfaceContainerMenu
extends AbstractResourceContainerMenu {
    private static final int DISK_SLOT_X1 = 44;
    private static final int DISK_SLOT_X2 = 116;
    private static final int DISK_SLOT_Y = 57;
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final Predicate<class_1657> stillValid;

    DiskInterfaceContainerMenu(int syncId, class_1657 player, AbstractDiskInterfaceBlockEntity blockEntity, DiskInventory diskInventory, ResourceContainer filterContainer, UpgradeContainer upgradeContainer) {
        super(Menus.INSTANCE.getDiskInterface(), syncId, player);
        this.addSlots(player, diskInventory, filterContainer, upgradeContainer);
        this.registerProperty(new ServerProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, blockEntity::getRedstoneMode, blockEntity::setRedstoneMode));
        this.registerProperty(new ServerProperty<Boolean>(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty(new ServerProperty<FilterMode>(PropertyTypes.FILTER_MODE, blockEntity::getFilterMode, blockEntity::setFilterMode));
        this.registerProperty(new ServerProperty<StorageTransferMode>(DiskInterfacePropertyTypes.TRANSFER_MODE, blockEntity::getTransferMode, blockEntity::setTransferMode));
        this.stillValid = p -> class_1263.method_49105((class_2586)blockEntity, (class_1657)p);
    }

    public DiskInterfaceContainerMenu(int syncId, class_1661 playerInventory, ResourceContainerData resourceContainerData) {
        super(Menus.INSTANCE.getDiskInterface(), syncId);
        this.addSlots(playerInventory.field_7546, new FilteredContainer(6, StorageContainerItem.stackValidator()), ResourceContainerImpl.createForFilter(resourceContainerData), new UpgradeContainer(UpgradeDestinations.DISK_INTERFACE));
        this.registerProperty(new ClientProperty<RedstoneMode>(PropertyTypes.REDSTONE_MODE, RedstoneMode.IGNORE));
        this.registerProperty(new ClientProperty<Boolean>(PropertyTypes.FUZZY_MODE, false));
        this.registerProperty(new ClientProperty<FilterMode>(PropertyTypes.FILTER_MODE, FilterMode.BLOCK));
        this.registerProperty(new ClientProperty<StorageTransferMode>(DiskInterfacePropertyTypes.TRANSFER_MODE, StorageTransferMode.INSERT_INTO_NETWORK));
        this.stillValid = p -> true;
    }

    private void addSlots(class_1657 player, FilteredContainer diskInventory, ResourceContainer filterContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < diskInventory.method_5439(); ++i) {
            this.method_7621(this.createDiskSlot(diskInventory, i));
        }
        for (i = 0; i < filterContainer.size(); ++i) {
            this.method_7621(this.createFilterSlot(filterContainer, i));
        }
        for (i = 0; i < upgradeContainer.method_5439(); ++i) {
            this.method_7621(new UpgradeSlot(upgradeContainer, i, 187, 6 + i * 18));
        }
        this.addPlayerInventory(player.method_31548(), 8, 129);
        this.transferManager.addBiTransfer((class_1263)player.method_31548(), (class_1263)upgradeContainer);
        this.transferManager.addBiTransfer((class_1263)player.method_31548(), (class_1263)diskInventory);
        this.transferManager.addFilterTransfer((class_1263)player.method_31548());
    }

    private class_1735 createFilterSlot(ResourceContainer filterContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(filterContainer, i, (class_2561)IdentifierUtil.createTranslation("gui", "disk_interface.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    private class_1735 createDiskSlot(FilteredContainer diskInventory, int i) {
        int x = i < 3 ? 44 : 116;
        int y = 57 + i % 3 * 18;
        return ValidatedSlot.forStorageContainer((class_1263)diskInventory, i, x, y);
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }
}

