/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlock;
import com.refinedmods.refinedstorage.common.iface.InterfaceProxyExternalStorageProvider;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainerImpl;
import com.refinedmods.refinedstorage.common.storage.externalstorage.CompositeExternalStorageProvider;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageTrackedStorageRepository;
import com.refinedmods.refinedstorage.common.storage.externalstorage.ExternalStorageWorkRate;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExternalStorageBlockEntity
extends AbstractCableLikeBlockEntity<ExternalStorageNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExternalStorageBlockEntity.class);
    private static final String TAG_TRACKED_RESOURCES = "tr";
    private final FilterWithFuzzyMode filter;
    private final StorageConfigurationContainerImpl configContainer;
    private final ExternalStorageTrackedStorageRepository trackedStorageRepository = new ExternalStorageTrackedStorageRepository(() -> ((AbstractExternalStorageBlockEntity)this).method_5431());
    private final ExternalStorageWorkRate workRate = new ExternalStorageWorkRate();
    private boolean initialized;

    protected AbstractExternalStorageBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getExternalStorage(), pos, state, new ExternalStorageNetworkNode(Platform.INSTANCE.getConfig().getExternalStorage().getEnergyUsage(), System::currentTimeMillis));
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(), () -> ((AbstractExternalStorageBlockEntity)this).method_5431(), ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration()::setFilters);
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(this.filter.createNormalizer());
        ((ExternalStorageNetworkNode)this.mainNetworkNode).setTrackingRepository(this.trackedStorageRepository);
        this.configContainer = new StorageConfigurationContainerImpl(((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration(), this.filter, () -> ((AbstractExternalStorageBlockEntity)this).method_5431(), this::getRedstoneMode, this::setRedstoneMode);
    }

    @Override
    public void method_31664(class_2680 newBlockState) {
        super.method_31664(newBlockState);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            LOGGER.debug("Reloading external storage @ {} as block state has changed", (Object)this.field_11867);
            this.loadStorage(serverLevel);
        }
    }

    @Override
    protected void activenessChanged(boolean newActive) {
        class_1937 class_19372;
        super.activenessChanged(newActive);
        if (!this.initialized && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            LOGGER.debug("Triggering initial load of external storage {}", (Object)this.field_11867);
            this.loadStorage(serverLevel);
            this.initialized = true;
        }
    }

    void loadStorage(class_3218 serverLevel) {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection(this.method_11010());
        LOGGER.debug("Loading storage for external storage with direction {} @ {}", (Object)direction, (Object)this.field_11867);
        if (direction == null) {
            return;
        }
        class_2350 incomingDirection = direction.method_10153();
        class_2338 sourcePosition = this.field_11867.method_10093(direction);
        if (serverLevel.method_8320(sourcePosition).method_26204() instanceof InterfaceBlock) {
            ((ExternalStorageNetworkNode)this.mainNetworkNode).initialize(new InterfaceProxyExternalStorageProvider((class_1937)serverLevel, sourcePosition));
        } else {
            ((ExternalStorageNetworkNode)this.mainNetworkNode).initialize(new CompositeExternalStorageProvider(RefinedStorageApi.INSTANCE.getExternalStorageProviderFactories().stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection)).toList()));
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.workRate.canDoWork()) {
            boolean hasChanges = ((ExternalStorageNetworkNode)this.mainNetworkNode).detectChanges();
            if (hasChanges) {
                LOGGER.debug("External storage @ {} has changed!", (Object)this.field_11867);
                this.workRate.faster();
            } else {
                this.workRate.slower();
            }
        }
    }

    public void neighborChanged() {
        this.workRate.faster();
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        tag.method_10566(TAG_TRACKED_RESOURCES, this.trackedStorageRepository.toTag(provider));
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
        this.configContainer.save(tag);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10545(TAG_TRACKED_RESOURCES)) {
            this.trackedStorageRepository.fromTag(Objects.requireNonNull(tag.method_10580(TAG_TRACKED_RESOURCES)), provider);
        }
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
        this.configContainer.load(tag);
    }

    void setFilters(Set<ResourceKey> filters) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    void setFilterMode(FilterMode mode) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilterMode(mode);
        this.method_5431();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void setAccessMode(AccessMode accessMode) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setAccessMode(accessMode);
    }

    void setPriority(int priority) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setInsertPriority(priority);
    }

    void setVoidExcess(boolean voidExcess) {
        ((ExternalStorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setVoidExcess(voidExcess);
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.EXTERNAL_STORAGE);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new ExternalStorageContainerMenu(syncId, player, this.filter.getFilterContainer(), this.configContainer, p -> class_1263.method_49105((class_2586)this, (class_1657)p));
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }
}

