/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.google.common.collect.Iterators;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import java.util.Iterator;
import java.util.List;

class CompositeExternalStorageProvider
implements ExternalStorageProvider {
    private final List<ExternalStorageProvider> providers;

    CompositeExternalStorageProvider(List<ExternalStorageProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Iterator<ResourceAmount> iterator() {
        return Iterators.concat(this.providers.stream().map(ExternalStorageProvider::iterator).toList().iterator());
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        for (ExternalStorageProvider provider : this.providers) {
            long extracted = provider.extract(resource, amount, action, actor);
            if (extracted <= 0L) continue;
            return extracted;
        }
        return 0L;
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        for (ExternalStorageProvider provider : this.providers) {
            long inserted = provider.insert(resource, amount, action, actor);
            if (inserted <= 0L) continue;
            return inserted;
        }
        return 0L;
    }
}

