/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.externalstorage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.tracked.InMemoryTrackedStorageRepository;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

class ExternalStorageTrackedStorageRepository
extends InMemoryTrackedStorageRepository {
    private static final Codec<ChangedByAt> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceCodecs.CODEC.fieldOf("resource").forGetter(ChangedByAt::resource), (App)Codec.STRING.fieldOf("changedBy").forGetter(ChangedByAt::changedBy), (App)Codec.LONG.fieldOf("changedAt").forGetter(ChangedByAt::changedAt)).apply((Applicative)instance, ChangedByAt::new));
    private static final Codec<List<ChangedByAt>> LIST_CODEC = Codec.list(CODEC);
    private final Runnable listener;

    ExternalStorageTrackedStorageRepository(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void update(ResourceKey resource, Actor actor, long time) {
        super.update(resource, actor, time);
        this.listener.run();
    }

    class_2520 toTag(class_7225.class_7874 provider) {
        return (class_2520)LIST_CODEC.encode(this.getTrackedResources(), (DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2499()).getOrThrow();
    }

    private List<ChangedByAt> getTrackedResources() {
        return this.trackedResourcesByActorType.getOrDefault(PlayerActor.class, Collections.emptyMap()).entrySet().stream().filter(entry -> entry.getKey() instanceof PlatformResourceKey).map(entry -> new ChangedByAt((PlatformResourceKey)entry.getKey(), ((TrackedResource)entry.getValue()).getSourceName(), ((TrackedResource)entry.getValue()).getTime())).toList();
    }

    void fromTag(class_2520 tag, class_7225.class_7874 provider) {
        LIST_CODEC.decode((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).ifSuccess(result -> ((List)result.getFirst()).forEach(changedByAt -> super.update(changedByAt.resource(), new PlayerActor(changedByAt.changedBy()), changedByAt.changedAt())));
    }

    private record ChangedByAt(PlatformResourceKey resource, String changedBy, long changedAt) {
    }
}

