/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.support.energy.TransferableBlockEntityEnergy;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridData;
import com.refinedmods.refinedstorage.common.grid.PortableGridData;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.storage.portablegrid.InWorldPortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlock;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockContainerMenu;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.RedstoneModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.energy.BlockEntityEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortableGridBlockEntity
extends class_2586
implements ExtendedMenuProvider<PortableGridData>,
ConfigurationCardTarget,
TransferableBlockEntityEnergy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPortableGridBlockEntity.class);
    private static final String TAG_DISK_INVENTORY = "inv";
    private static final String TAG_DISKS = "disks";
    private static final String TAG_REDSTONE_MODE = "rm";
    private static final String TAG_CUSTOM_NAME = "CustomName";
    @Nullable
    protected Disk disk;
    @Nullable
    private class_2561 name;
    private final DiskInventory diskInventory;
    private final DiskStateChangeListener diskStateListener = new DiskStateChangeListener(this);
    private final EnergyStorage energyStorage;
    private final RateLimiter activenessChangeRateLimiter = RateLimiter.create((double)1.0);
    private final PortableGrid grid;
    private final PortableGridType type;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    protected AbstractPortableGridBlockEntity(PortableGridType type, class_2338 pos, class_2680 state) {
        super(AbstractPortableGridBlockEntity.getBlockEntityType(type), pos, state);
        this.diskInventory = new DiskInventory((inventory, slot) -> this.onDiskChanged(), 1);
        this.energyStorage = AbstractPortableGridBlockEntity.createEnergyStorage(type, this);
        this.grid = new InWorldPortableGrid(this.energyStorage, this.diskInventory, this.diskStateListener, this);
        this.type = type;
    }

    static void readDiskInventory(class_2487 tag, DiskInventory diskInventory, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_DISK_INVENTORY)) {
            ContainerUtil.read(tag.method_10562(TAG_DISK_INVENTORY), (class_1263)diskInventory, provider);
        }
    }

    static void writeDiskInventory(class_2487 tag, DiskInventory diskInventory, class_7225.class_7874 provider) {
        tag.method_10566(TAG_DISK_INVENTORY, (class_2520)ContainerUtil.write((class_1263)diskInventory, provider));
    }

    static class_1799 getDisk(class_9279 customData, class_7225.class_7874 provider) {
        class_2487 tag = customData.method_57461();
        if (!tag.method_10545(TAG_DISK_INVENTORY)) {
            return class_1799.field_8037;
        }
        return ContainerUtil.getItemInSlot(tag.method_10562(TAG_DISK_INVENTORY), 0, provider);
    }

    private static EnergyStorage createEnergyStorage(PortableGridType type, class_2586 blockEntity) {
        if (type == PortableGridType.CREATIVE) {
            return CreativeEnergyStorage.INSTANCE;
        }
        return new BlockEntityEnergyStorage(new EnergyStorageImpl(Platform.INSTANCE.getConfig().getPortableGrid().getEnergyCapacity()), blockEntity);
    }

    Grid getGrid() {
        return this.grid;
    }

    void update(class_2680 state) {
        boolean activenessNeedsUpdate;
        this.diskStateListener.updateIfNecessary();
        boolean newActive = this.grid.isGridActive();
        boolean bl = activenessNeedsUpdate = (Boolean)state.method_11654((class_2769)PortableGridBlock.ACTIVE) != newActive;
        if (activenessNeedsUpdate && this.activenessChangeRateLimiter.tryAcquire()) {
            this.updateActivenessBlockState(state, newActive);
            this.grid.activeChanged(newActive);
        }
    }

    private void updateActivenessBlockState(class_2680 state, boolean active) {
        if (this.field_11863 != null) {
            LOGGER.debug("Sending block update at {} due to activeness change: {} -> {}", new Object[]{this.method_11016(), state.method_11654((class_2769)PortableGridBlock.ACTIVE), active});
            this.field_11863.method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)PortableGridBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    private void onDiskChanged() {
        boolean isJustPlacedIntoLevelOrLoading;
        boolean bl = isJustPlacedIntoLevelOrLoading = this.field_11863 == null || this.field_11863.method_8608();
        if (isJustPlacedIntoLevelOrLoading) {
            return;
        }
        this.grid.updateStorage();
        PlatformUtil.sendBlockUpdateToClient(this.field_11863, this.field_11867);
        this.method_5431();
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (!level.method_8608()) {
            this.initialize(level);
        }
    }

    private void initialize(class_1937 level) {
        this.diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository(level));
        this.grid.updateStorage();
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.fromClientTag(tag);
        AbstractPortableGridBlockEntity.readDiskInventory(tag, this.diskInventory, provider);
        ItemBlockEnergyStorage.readFromTag(this.energyStorage, tag);
        this.readConfiguration(tag, provider);
        super.method_11014(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_REDSTONE_MODE)) {
            this.redstoneMode = RedstoneModeSettings.getRedstoneMode(tag.method_10550(TAG_REDSTONE_MODE));
        }
        if (tag.method_10573(TAG_CUSTOM_NAME, 8)) {
            this.name = AbstractPortableGridBlockEntity.method_59894((String)tag.method_10558(TAG_CUSTOM_NAME), (class_7225.class_7874)provider);
        }
    }

    private void fromClientTag(class_2487 tag) {
        if (!tag.method_10545(TAG_DISKS)) {
            return;
        }
        this.disk = this.diskInventory.fromSyncTag(tag.method_10554(TAG_DISKS, 10))[0];
        this.onClientDriveStateUpdated();
    }

    protected void onClientDriveStateUpdated() {
        if (this.field_11863 == null) {
            return;
        }
        Platform.INSTANCE.requestModelDataUpdateOnClient((class_1936)this.field_11863, this.field_11867, true);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        AbstractPortableGridBlockEntity.writeDiskInventory(tag, this.diskInventory, provider);
        ItemBlockEnergyStorage.writeToTag(tag, this.energyStorage.getStored());
        this.writeConfiguration(tag, provider);
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10569(TAG_REDSTONE_MODE, RedstoneModeSettings.getRedstoneMode(this.redstoneMode));
        if (this.name != null) {
            tag.method_10582(TAG_CUSTOM_NAME, class_2561.class_2562.method_10867((class_2561)this.name, (class_7225.class_7874)provider));
        }
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        this.name = (class_2561)componentInput.method_58694(class_9334.field_49631);
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(class_9334.field_49631, (Object)this.name);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        tag.method_10566(TAG_DISKS, (class_2520)this.diskInventory.toSyncTag(idx -> this.grid.getStorageState()));
        return tag;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        this.method_5431();
    }

    public class_2561 method_5476() {
        class_5250 defaultName = this.type == PortableGridType.CREATIVE ? ContentNames.CREATIVE_PORTABLE_GRID : ContentNames.PORTABLE_GRID;
        return this.name == null ? defaultName : this.name;
    }

    @Nullable
    public AbstractGridContainerMenu createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new PortableGridBlockContainerMenu(syncId, inventory, this);
    }

    @Override
    public PortableGridData getMenuData() {
        return new PortableGridData(GridData.of(this.grid), this.energyStorage.getStored(), this.energyStorage.getCapacity(), Optional.empty());
    }

    @Override
    public class_9142<class_9129, PortableGridData> getMenuCodec() {
        return PortableGridData.STREAM_CODEC;
    }

    DiskInventory getDiskInventory() {
        return this.diskInventory;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private static class_2591<AbstractPortableGridBlockEntity> getBlockEntityType(PortableGridType type) {
        return type == PortableGridType.CREATIVE ? BlockEntities.INSTANCE.getCreativePortableGrid() : BlockEntities.INSTANCE.getPortableGrid();
    }
}

