/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.AbstractProxyEnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractEnergyBlockItem;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.portablegrid.AbstractPortableGridBlockEntity;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItemRenderInfo;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridItemExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class PortableGridBlockItem
extends AbstractEnergyBlockItem
implements SlotReferenceHandlerItem {
    private static final class_2561 HELP = IdentifierUtil.createTranslation("item", "portable_grid.help");
    private final PortableGridType type;

    public PortableGridBlockItem(class_2248 block, PortableGridType type) {
        super(block, new class_1792.class_1793().method_7889(1), RefinedStorageApi.INSTANCE.getEnergyItemHelper());
        this.type = type;
    }

    public static PortableGridBlockItemRenderInfo getRenderInfo(class_1799 stack, class_1937 level) {
        boolean creative = PortableGridBlockItem.isCreative(stack);
        boolean hasEnergy = creative || PortableGridBlockItem.createEnergyStorage(stack).getStored() > 0L;
        class_1799 diskStack = PortableGridBlockItem.getDisk(stack, (class_7225.class_7874)level.method_30349());
        boolean active = hasEnergy && !diskStack.method_7960();
        Disk disk = new Disk(diskStack.method_7960() ? null : diskStack.method_7909(), PortableGridBlockItem.getState(diskStack, active));
        return new PortableGridBlockItemRenderInfo(active, disk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCreative(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof PortableGridBlockItem)) return false;
        PortableGridBlockItem portableGridBlockItem = (PortableGridBlockItem)class_17922;
        if (portableGridBlockItem.type != PortableGridType.CREATIVE) return false;
        return true;
    }

    private static StorageState getState(class_1799 diskStack, boolean active) {
        class_1792 class_17922;
        if (diskStack.method_7960() || !((class_17922 = diskStack.method_7909()) instanceof StorageContainerItem)) {
            return StorageState.NONE;
        }
        StorageContainerItem storageContainerItem = (StorageContainerItem)class_17922;
        if (!active) {
            return StorageState.INACTIVE;
        }
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        return storageContainerItem.getInfo(storageRepository, diskStack).map(storageInfo -> StateTrackedStorage.computeState(storageInfo.capacity(), storageInfo.stored())).orElse(StorageState.INACTIVE);
    }

    private static class_1799 getDisk(class_1799 stack, class_7225.class_7874 provider) {
        class_9279 blockEntityData = (class_9279)stack.method_57824(class_9334.field_49611);
        if (blockEntityData == null) {
            return class_1799.field_8037;
        }
        return AbstractPortableGridBlockEntity.getDisk(blockEntityData, provider);
    }

    static void setDiskInventory(class_1799 stack, DiskInventory diskInventory, class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        AbstractPortableGridBlockEntity.writeDiskInventory(tag, diskInventory, provider);
        ItemBlockEnergyStorage.writeToTag(tag, PortableGridBlockItem.createEnergyStorage(stack).getStored());
        PortableGridBlockItem.method_57338((class_1799)stack, PortableGridBlockItem.isCreative(stack) ? BlockEntities.INSTANCE.getCreativePortableGrid() : BlockEntities.INSTANCE.getPortableGrid(), (class_2487)tag);
    }

    public static EnergyStorage createEnergyStorage(class_1799 stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.INSTANCE.getConfig().getPortableGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asBlockItemEnergyStorage(energyStorage, stack, BlockEntities.INSTANCE.getPortableGrid());
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        if (player.method_18276()) {
            return super.method_7884(context);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, context.method_20287());
            slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (class_1799)s, slotReference));
        }
        return class_1269.field_21466;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (level.method_8503() != null) {
                SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (class_1799)s, slotReference));
            }
        }
        return class_1271.method_22428((Object)stack);
    }

    @Override
    public void use(class_3222 player, class_1799 stack, SlotReference slotReference) {
        PortableGrid portableGrid;
        PortableGridEnergyStorage energyStorage = this.createEnergyStorageInternal(stack);
        class_3218 level = player.method_51469();
        DiskInventoryListenerImpl listener = new DiskInventoryListenerImpl(stack, (class_7225.class_7874)level.method_30349());
        DiskInventory diskInventory = this.createDiskInventory(stack, listener, (class_7225.class_7874)level.method_30349());
        diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository((class_1937)level));
        listener.portableGrid = portableGrid = new PortableGrid(energyStorage, diskInventory, () -> {});
        energyStorage.portableGrid = portableGrid;
        portableGrid.updateStorage();
        Platform.INSTANCE.getMenuOpener().openMenu(player, new PortableGridItemExtendedMenuProvider((class_2561)Objects.requireNonNullElse((class_2561)stack.method_57824(class_9334.field_49631), this.type == PortableGridType.CREATIVE ? ContentNames.CREATIVE_PORTABLE_GRID : ContentNames.PORTABLE_GRID), portableGrid, energyStorage, diskInventory, slotReference));
    }

    private PortableGridEnergyStorage createEnergyStorageInternal(class_1799 stack) {
        if (this.type == PortableGridType.CREATIVE) {
            return new PortableGridEnergyStorage(CreativeEnergyStorage.INSTANCE);
        }
        return new PortableGridEnergyStorage(PortableGridBlockItem.createEnergyStorage(stack));
    }

    private DiskInventory createDiskInventory(class_1799 stack, DiskInventoryListenerImpl listener, class_7225.class_7874 provider) {
        DiskInventory diskInventory = new DiskInventory(listener, 1);
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49611);
        if (customData != null) {
            AbstractPortableGridBlockEntity.readDiskInventory(customData.method_57461(), diskInventory, provider);
        }
        return diskInventory;
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new HelpTooltipComponent(HELP));
    }

    private static class PortableGridEnergyStorage
    extends AbstractProxyEnergyStorage {
        @Nullable
        private PortableGrid portableGrid;

        private PortableGridEnergyStorage(EnergyStorage energyStorage) {
            super(energyStorage);
        }

        @Override
        public long extract(long amount, Action action) {
            if (action == Action.EXECUTE && this.portableGrid != null) {
                boolean wasActive = this.portableGrid.isGridActive();
                long extracted = super.extract(amount, action);
                boolean isActive = this.portableGrid.isGridActive();
                if (wasActive != isActive) {
                    this.portableGrid.activeChanged(isActive);
                }
                return extracted;
            }
            return super.extract(amount, action);
        }
    }

    private static class DiskInventoryListenerImpl
    implements DiskInventory.DiskListener {
        private final class_1799 portableGridStack;
        private final class_7225.class_7874 provider;
        @Nullable
        private PortableGrid portableGrid;

        private DiskInventoryListenerImpl(class_1799 portableGridStack, class_7225.class_7874 provider) {
            this.portableGridStack = portableGridStack;
            this.provider = provider;
        }

        @Override
        public void onDiskChanged(DiskInventory inventory, int slot) {
            boolean stillLoading;
            boolean bl = stillLoading = this.portableGrid == null;
            if (stillLoading) {
                return;
            }
            PortableGridBlockItem.setDiskInventory(this.portableGridStack, inventory, this.provider);
            boolean wasActive = this.portableGrid.isGridActive();
            this.portableGrid.updateStorage();
            boolean isActive = this.portableGrid.isGridActive();
            if (wasActive != isActive) {
                this.portableGrid.activeChanged(isActive);
            }
        }
    }
}

