/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.Menus;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_3917;

public class ItemStorageBlockProvider
implements StorageBlockProvider {
    private final ItemStorageVariant variant;
    private final class_2561 displayName;

    public ItemStorageBlockProvider(ItemStorageVariant variant) {
        this.variant = variant;
        this.displayName = IdentifierUtil.createTranslation("block", String.format("%s_storage_block", variant.getName()));
    }

    @Override
    public SerializableStorage createStorage(Runnable listener) {
        return StorageTypes.ITEM.create(this.variant.getCapacity(), listener);
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public long getEnergyUsage() {
        return switch (this.variant) {
            default -> throw new MatchException(null, null);
            case ItemStorageVariant.ONE_K -> Platform.INSTANCE.getConfig().getStorageBlock().get1kEnergyUsage();
            case ItemStorageVariant.FOUR_K -> Platform.INSTANCE.getConfig().getStorageBlock().get4kEnergyUsage();
            case ItemStorageVariant.SIXTEEN_K -> Platform.INSTANCE.getConfig().getStorageBlock().get16kEnergyUsage();
            case ItemStorageVariant.SIXTY_FOUR_K -> Platform.INSTANCE.getConfig().getStorageBlock().get64kEnergyUsage();
            case ItemStorageVariant.CREATIVE -> Platform.INSTANCE.getConfig().getStorageBlock().getCreativeEnergyUsage();
        };
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return RefinedStorageApi.INSTANCE.getItemResourceFactory();
    }

    @Override
    public class_2591<?> getBlockEntityType() {
        return BlockEntities.INSTANCE.getItemStorageBlock(this.variant);
    }

    @Override
    public class_3917<?> getMenuType() {
        return Menus.INSTANCE.getItemStorage();
    }
}

