/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.AccessMode;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockEntity;
import com.refinedmods.refinedstorage.common.api.storage.StorageBlockProvider;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainerImpl;
import com.refinedmods.refinedstorage.common.storage.storageblock.StorageBlockContainerMenu;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBlockBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<StorageNetworkNode>
implements NetworkNodeExtendedMenuProvider<StorageBlockData>,
StorageBlockEntity,
AbstractStorageContainerNetworkNode.Provider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageBlockBlockEntity.class);
    private static final String TAG_STORAGE_ID = "sid";
    protected final StorageConfigurationContainerImpl configContainer;
    private final FilterWithFuzzyMode filter;
    private final class_2561 displayName;
    private final StorageBlockProvider storageBlockProvider;
    @Nullable
    private UUID storageId;

    public StorageBlockBlockEntity(class_2338 pos, class_2680 state, StorageBlockProvider provider) {
        super(provider.getBlockEntityType(), pos, state, new StorageNetworkNode(provider.getEnergyUsage(), 0L, 1));
        this.filter = FilterWithFuzzyMode.createAndListenForUniqueFilters(ResourceContainerImpl.createForFilter(provider.getResourceFactory()), () -> ((StorageBlockBlockEntity)this).method_5431(), this::setFilters);
        this.configContainer = new StorageConfigurationContainerImpl(((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration(), this.filter, () -> ((StorageBlockBlockEntity)this).method_5431(), this::getRedstoneMode, this::setRedstoneMode);
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setNormalizer(this.filter.createNormalizer());
        this.displayName = provider.getDisplayName();
        this.storageBlockProvider = provider;
    }

    @Override
    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.method_8608()) {
            return;
        }
        if (this.storageId == null) {
            this.storageId = UUID.randomUUID();
            StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(level);
            SerializableStorage storage = this.storageBlockProvider.createStorage(storageRepository::markAsChanged);
            storageRepository.set(this.storageId, storage);
        }
        ((StorageNetworkNode)this.mainNetworkNode).setProvider(this);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_STORAGE_ID)) {
            this.setStorageId(tag.method_25926(TAG_STORAGE_ID));
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.configContainer.load(tag);
        this.filter.load(tag, provider);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.storageId != null) {
            tag.method_25927(TAG_STORAGE_ID, this.storageId);
        }
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.configContainer.save(tag);
        this.filter.save(tag, provider);
    }

    @Override
    public void setStorageId(UUID storageId) {
        this.tryRemoveCurrentStorage(storageId);
        this.storageId = storageId;
        ((StorageNetworkNode)this.mainNetworkNode).onStorageChanged(0);
    }

    private void tryRemoveCurrentStorage(UUID newStorageId) {
        if (this.field_11863 == null || this.storageId == null || this.storageId.equals(newStorageId)) {
            return;
        }
        LOGGER.info("Updating storage ID from {} to {}. Removing old storage", (Object)this.storageId, (Object)newStorageId);
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(this.field_11863);
        storageRepository.removeIfEmpty(this.storageId).ifPresentOrElse(storage -> LOGGER.info("Storage {} successfully removed", (Object)this.storageId), () -> LOGGER.warn("Storage {} could not be removed", (Object)this.storageId));
    }

    void setFilters(Set<ResourceKey> filters) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilters(filters);
    }

    void setFilterMode(FilterMode mode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setFilterMode(mode);
        this.method_5431();
    }

    void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    void setAccessMode(AccessMode accessMode) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setAccessMode(accessMode);
    }

    void setVoidExcess(boolean voidExcess) {
        ((StorageNetworkNode)this.mainNetworkNode).getStorageConfiguration().setVoidExcess(voidExcess);
    }

    @Override
    @Nullable
    public UUID getStorageId() {
        return this.storageId;
    }

    protected final ResourceContainer getFilterContainer() {
        return this.filter.getFilterContainer();
    }

    @Override
    public StorageBlockData getMenuData() {
        return new StorageBlockData(((StorageNetworkNode)this.mainNetworkNode).getStored(), ((StorageNetworkNode)this.mainNetworkNode).getCapacity(), ResourceContainerData.of(this.filter.getFilterContainer()).resources());
    }

    @Override
    public class_9142<class_9129, StorageBlockData> getMenuCodec() {
        return RefinedStorageApi.INSTANCE.getStorageBlockDataStreamCodec();
    }

    @Override
    public Optional<Storage> resolve(int index) {
        if (this.field_11863 == null || this.storageId == null) {
            return Optional.empty();
        }
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getStorageRepository(this.field_11863);
        return storageRepository.get(this.storageId).map(Storage.class::cast);
    }

    public class_2561 method_5477() {
        return this.overrideName(this.displayName);
    }

    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new StorageBlockContainerMenu(this.storageBlockProvider.getMenuType(), syncId, player, this.filter.getFilterContainer(), this.configContainer, p -> class_1263.method_49105((class_2586)this, (class_1657)p));
    }
}

