/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storageblock;

import com.refinedmods.refinedstorage.common.api.storage.StorageBlockData;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.storage.AbstractStorageContainerMenu;
import com.refinedmods.refinedstorage.common.storage.StorageAccessor;
import com.refinedmods.refinedstorage.common.storage.StorageConfigurationContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_3917;

public class StorageBlockContainerMenu
extends AbstractStorageContainerMenu
implements StorageAccessor {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final Predicate<class_1657> stillValid;
    private long stored;
    private long capacity;

    public StorageBlockContainerMenu(class_3917<?> type, int syncId, class_1657 player, StorageBlockData storageBlockData, ResourceFactory resourceFactory) {
        super(type, syncId);
        this.stored = storageBlockData.stored();
        this.capacity = storageBlockData.capacity();
        this.addSlots(player, ResourceContainerImpl.createForFilter(resourceFactory, storageBlockData.resources()));
        this.stillValid = p -> true;
    }

    public StorageBlockContainerMenu(class_3917<?> type, int syncId, class_1657 player, ResourceContainer resourceContainer, StorageConfigurationContainer configContainer, Predicate<class_1657> stillValid) {
        super(type, syncId, player, configContainer);
        this.addSlots(player, resourceContainer);
        this.stillValid = stillValid;
    }

    private void addSlots(class_1657 player, ResourceContainer resourceContainer) {
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.method_7621(this.createFilterSlot(resourceContainer, i));
        }
        this.addPlayerInventory(player.method_31548(), 8, 141);
        this.transferManager.addFilterTransfer((class_1263)player.method_31548());
    }

    private class_1735 createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, (class_2561)IdentifierUtil.createTranslation("gui", "storage.filter_help"), x, 20, ResourceSlotType.FILTER);
    }

    @Override
    public double getProgress() {
        if (this.capacity == 0L) {
            return 0.0;
        }
        return (double)this.getStored() / (double)this.getCapacity();
    }

    @Override
    public boolean hasCapacity() {
        return this.capacity > 0L;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    public boolean method_7597(class_1657 player) {
        return this.stillValid.test(player);
    }
}

