/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.storagedisk;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5632;

public class ItemStorageDiskItem
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private static final class_2561 CREATIVE_HELP = IdentifierUtil.createTranslation("item", "creative_storage_disk.help");
    private final ItemStorageVariant variant;
    private final class_2561 helpText;

    public ItemStorageDiskItem(ItemStorageVariant variant) {
        super(new class_1792.class_1793().method_7889(1).method_24359(), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = ItemStorageDiskItem.getHelpText(variant);
    }

    private static class_2561 getHelpText(ItemStorageVariant variant) {
        return variant.getCapacity() == null ? CREATIVE_HELP : IdentifierUtil.createTranslation("item", "storage_disk.help", IdentifierUtil.format(variant.getCapacity()));
    }

    @Override
    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    @Override
    protected String formatAmount(long amount) {
        return IdentifierUtil.format(amount);
    }

    @Override
    protected SerializableStorage createStorage(StorageRepository storageRepository) {
        return StorageTypes.ITEM.create(this.variant.getCapacity(), storageRepository::markAsChanged);
    }

    @Override
    protected class_1799 createPrimaryDisassemblyByproduct(int count) {
        return new class_1799((class_1935)Items.INSTANCE.getStorageHousing(), count);
    }

    @Override
    @Nullable
    protected class_1799 createSecondaryDisassemblyByproduct(int count) {
        if (this.variant == ItemStorageVariant.CREATIVE) {
            return null;
        }
        return new class_1799((class_1935)Items.INSTANCE.getItemStoragePart(this.variant), count);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    @Override
    public StorageVariant getVariant() {
        return this.variant;
    }

    @Override
    public void transferTo(class_1799 from, class_1799 to) {
        this.helper.markAsToTransfer(from, to);
    }
}

