/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.storagemonitor.StorageMonitorInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.FluidOperationResult;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1799;

public class FluidStorageMonitorInsertionStrategy
implements StorageMonitorInsertionStrategy {
    @Override
    public Optional<class_1799> insert(ResourceKey configuredResource, class_1799 stack, Actor actor, Network network) {
        if (!(configuredResource instanceof FluidResource)) {
            return Optional.empty();
        }
        FluidResource configuredFluidResource = (FluidResource)configuredResource;
        RootStorage fluidRootStorage = network.getComponent(StorageNetworkComponent.class);
        return Platform.INSTANCE.drainContainer(stack).map(extracted -> this.tryInsert(actor, configuredFluidResource, (FluidOperationResult)extracted, fluidRootStorage)).map(extracted -> this.doInsert(actor, (FluidOperationResult)extracted, fluidRootStorage));
    }

    @Nullable
    private FluidOperationResult tryInsert(Actor actor, FluidResource configuredResource, FluidOperationResult result, RootStorage rootStorage) {
        if (!result.fluid().equals(configuredResource)) {
            return null;
        }
        long insertedSimulated = rootStorage.insert(result.fluid(), result.amount(), Action.SIMULATE, actor);
        boolean insertedSuccessfully = insertedSimulated == result.amount();
        return insertedSuccessfully ? result : null;
    }

    private class_1799 doInsert(Actor actor, FluidOperationResult result, RootStorage rootStorage) {
        rootStorage.insert(result.fluid(), result.amount(), Action.EXECUTE, actor);
        return result.container();
    }
}

